/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.mcmc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MyConnectionMyChoice
implements ClientModInitializer {
    private static MyConnectionMyChoice INSTANCE;
    private final Logger logger = LogManager.getLogger((String)"MyConnectionMyChoice");
    private final Path config = FabricLoader.getInstance().getConfigDir().resolve("mcmc.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private boolean keepConnectionInConfirmScreen = false;
    private boolean hideTransferConnectionIntent = false;
    private boolean clearCookiesOnTransfer = false;

    public void onInitializeClient() {
        INSTANCE = this;
        if (Files.exists(this.config, new LinkOption[0])) {
            try {
                JsonObject object = (JsonObject)this.gson.fromJson(Files.readString(this.config), JsonObject.class);
                this.keepConnectionInConfirmScreen = object.get("keepConnectionInConfirmScreen").getAsBoolean();
                this.hideTransferConnectionIntent = object.get("hideTransferConnectionIntent").getAsBoolean();
                this.clearCookiesOnTransfer = object.get("clearCookiesOnTransfer").getAsBoolean();
            }
            catch (Exception e) {
                this.logger.error("Failed to read file: {}!", (Object)this.config.toString(), (Object)e);
            }
        }
    }

    private void save() {
        try {
            JsonObject object = new JsonObject();
            object.addProperty("keepConnectionInConfirmScreen", Boolean.valueOf(this.keepConnectionInConfirmScreen));
            object.addProperty("hideTransferConnectionIntent", Boolean.valueOf(this.hideTransferConnectionIntent));
            object.addProperty("clearCookiesOnTransfer", Boolean.valueOf(this.clearCookiesOnTransfer));
            Files.writeString(this.config, (CharSequence)this.gson.toJson((JsonElement)object), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            this.logger.error("Failed to create file: {}!", (Object)this.config.toString(), (Object)e);
        }
    }

    public boolean keepConnectionInConfirmScreen() {
        return this.keepConnectionInConfirmScreen;
    }

    public void setKeepConnectionInConfirmScreen(boolean keepConnectionInConfirmScreen) {
        this.keepConnectionInConfirmScreen = keepConnectionInConfirmScreen;
        this.save();
    }

    public boolean hideTransferConnectionIntent() {
        return this.hideTransferConnectionIntent;
    }

    public void setHideTransferConnectionIntent(boolean hideTransferConnectionIntent) {
        this.hideTransferConnectionIntent = hideTransferConnectionIntent;
        this.save();
    }

    public boolean clearCookiesOnTransfer() {
        return this.clearCookiesOnTransfer;
    }

    public void setClearCookiesOnTransfer(boolean clearCookiesOnTransfer) {
        this.clearCookiesOnTransfer = clearCookiesOnTransfer;
        this.save();
    }

    public static MyConnectionMyChoice instance() {
        return INSTANCE;
    }
}

