/*
 * Decompiled with CFR 0.152.
 */
package com.artur114.armoredarms.client.core;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ClientChatEvent;

public class AAClientCommandsManager {
    private final Set<IAACommand> commands = new HashSet<IAACommand>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private IAACommand lastCommand = null;

    public AAClientCommandsManager() {
        this.addCommand(new CommandCopyItemName());
    }

    public void clientChatEvent(ClientChatEvent e) {
        if (e.getMessage().equals("&aahelp")) {
            e.setCanceled(true);
            this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("&aac - Executes the last executed command."));
            this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("&aahelp - Displays a list of all commands and their descriptions."));
            for (IAACommand command : this.commands) {
                this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(command.name() + " - " + command.description()));
            }
        }
        if (e.getMessage().equals("&aac")) {
            e.setCanceled(true);
            if (this.lastCommand != null) {
                this.lastCommand.execute(this.mc.field_71439_g);
            }
            return;
        }
        for (IAACommand command : this.commands) {
            if (!command.name().equals(e.getMessage())) continue;
            command.execute(this.mc.field_71439_g);
            this.lastCommand = command;
            e.setCanceled(true);
            break;
        }
    }

    public void addCommand(IAACommand command) {
        this.commands.add(command);
    }

    public static class CommandCopyItemName
    implements IAACommand {
        @Override
        public String name() {
            return "&aacopyitemname";
        }

        @Override
        public String description() {
            return "Outputs to the console and copies the indicator of the item in the main hand.";
        }

        @Override
        public void execute(EntityPlayerSP player) {
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_190926_b()) {
                return;
            }
            ResourceLocation registryName = stack.func_77973_b().getRegistryName();
            if (registryName == null) {
                return;
            }
            String itemName = registryName.toString();
            player.func_145747_a((ITextComponent)new TextComponentString("Id: " + itemName));
            this.copyToClipboard(itemName);
        }

        private void copyToClipboard(String text) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(text);
            cb.setContents(data, null);
        }
    }

    public static interface IAACommand {
        public String name();

        public String description();

        public void execute(EntityPlayerSP var1);
    }
}

