/*
 * Decompiled with CFR 0.152.
 */
package com.artur114.armoredarms.client.core;

import com.artur114.armoredarms.api.IArmRenderLayer;
import com.artur114.armoredarms.client.util.MiscUtils;
import com.artur114.armoredarms.client.util.ShapelessRL;
import com.artur114.armoredarms.main.AAConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmRenderLayerVanilla
implements IArmRenderLayer {
    public List<ShapelessRL> renderArmWearList = null;
    public boolean currentArmorModelBiped = true;
    public ModelBiped baseArmorModel = null;
    public RenderPlayer renderPlayer = null;
    public ItemStack chestPlate = null;

    @Override
    public void update(AbstractClientPlayer player) {
        ItemStack chestPlate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (this.chestPlate != chestPlate) {
            this.chestPlate = chestPlate;
            if (chestPlate.func_77973_b() instanceof ItemArmor) {
                ModelBiped armor = chestPlate.func_77973_b().getArmorModel((EntityLivingBase)player, chestPlate, EntityEquipmentSlot.CHEST, this.baseArmorModel);
                this.currentArmorModelBiped = this.renderArmWearList.contains((Object)new ShapelessRL(chestPlate.func_77973_b().getRegistryName())) || armor == null || armor.getClass() == ModelBiped.class;
            }
        }
    }

    @Override
    public void renderTransformed(AbstractClientPlayer player, EnumHandSide handSide) {
        if (player.func_82150_aj()) {
            return;
        }
        ModelPlayer playerModel = this.renderPlayer.func_177087_b();
        ModelRenderer armWear = this.handFromModelPlayer(playerModel, handSide, true);
        ModelRenderer arm = this.handFromModelPlayer(playerModel, handSide, false);
        this.renderPlayer.func_110776_a(player.func_110306_p());
        this.render(armWear, handSide);
        this.render(arm, handSide);
    }

    @Override
    public boolean needRender(AbstractClientPlayer player, boolean renderManagerState) {
        return renderManagerState;
    }

    @Override
    public void init(AbstractClientPlayer player) {
        this.renderPlayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player);
        this.baseArmorModel = new ModelBiped(1.0f);
        this.renderArmWearList = this.initRenderArmWearList();
    }

    public List<ShapelessRL> initRenderArmWearList() {
        ArrayList<ShapelessRL> ret = new ArrayList<ShapelessRL>(AAConfig.renderArmWearList.length);
        for (String id : AAConfig.renderArmWearList) {
            ShapelessRL rl = new ShapelessRL(id);
            if (rl.isEmpty()) continue;
            ret.add(rl);
        }
        return ret;
    }

    public ModelRenderer handFromModelPlayer(ModelPlayer mb, EnumHandSide handSide, boolean wear) {
        if (wear && AAConfig.disableArmWear && (!AAConfig.enableArmWearWithVanillaM || !this.currentArmorModelBiped)) {
            return null;
        }
        switch (handSide) {
            case RIGHT: {
                return wear ? mb.field_178732_b : mb.field_178723_h;
            }
            case LEFT: {
                return wear ? mb.field_178734_a : mb.field_178724_i;
            }
        }
        return null;
    }

    private void render(ModelRenderer arm, EnumHandSide handSide) {
        if (arm == null) {
            return;
        }
        arm.field_78795_f = 0.0f;
        arm.field_78796_g = 0.0f;
        arm.field_78808_h = 0.1f * (float)MiscUtils.handSideDelta(handSide);
        arm.func_78785_a(0.0625f);
    }
}

