/*
 * Decompiled with CFR 0.152.
 */
package com.artur114.armoredarms.api;

import com.artur114.armoredarms.api.IArmRenderLayer;
import com.artur114.armoredarms.api.IOverrider;
import com.artur114.armoredarms.api.IOverriderGetModel;
import com.artur114.armoredarms.api.IOverriderGetTex;
import com.artur114.armoredarms.api.IOverriderRender;
import com.artur114.armoredarms.client.util.ShapelessRL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmoredArmsApi {

    public static class InitArmorRenderLayerEvent
    extends Event {
        private final Map<ShapelessRL, IOverriderGetModel> modelOverriders = new HashMap<ShapelessRL, IOverriderGetModel>();
        private final Map<ShapelessRL, IOverriderGetTex> textureOverriders = new HashMap<ShapelessRL, IOverriderGetTex>();
        private final Map<ShapelessRL, IOverriderRender> renderOverriders = new HashMap<ShapelessRL, IOverriderRender>();
        private final Set<ShapelessRL> renderBlackList = new HashSet<ShapelessRL>();

        public void registerOverrider(String modid, String itemName, IOverrider overrider, boolean replaceIfHas) {
            ShapelessRL rl = new ShapelessRL(modid, itemName);
            if (rl.isEmpty()) {
                return;
            }
            if (overrider instanceof IOverriderRender && (!this.renderOverriders.containsKey((Object)rl) || replaceIfHas)) {
                this.renderOverriders.put(rl, (IOverriderRender)overrider);
                System.out.println("Added overrider render! for [" + (Object)((Object)rl) + "]");
            }
            if (overrider instanceof IOverriderGetTex && (!this.textureOverriders.containsKey((Object)rl) || replaceIfHas)) {
                this.textureOverriders.put(rl, (IOverriderGetTex)overrider);
                System.out.println("Added overrider get texture! for [" + (Object)((Object)rl) + "]");
            }
            if (overrider instanceof IOverriderGetModel && (!this.modelOverriders.containsKey((Object)rl) || replaceIfHas)) {
                this.modelOverriders.put(rl, (IOverriderGetModel)overrider);
                System.out.println("Added overrider get model! for [" + (Object)((Object)rl) + "]");
            }
        }

        public void addArmorToBlackList(String modid, String itemName) {
            ShapelessRL rl = new ShapelessRL(modid, itemName);
            if (!rl.isEmpty()) {
                this.renderBlackList.add(rl);
            }
        }

        public void addArmorToBlackList(String[] rls) {
            if (rls == null) {
                return;
            }
            for (String str : rls) {
                ShapelessRL rl = null;
                try {
                    rl = new ShapelessRL(str);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                if (rl == null || rl.isEmpty()) continue;
                this.renderBlackList.add(rl);
            }
        }

        public boolean removeOverrider(String modid, String itemName) {
            ShapelessRL rl = new ShapelessRL(modid, itemName);
            boolean flag = false;
            flag |= this.textureOverriders.remove((Object)rl) != null;
            flag |= this.renderOverriders.remove((Object)rl) != null;
            return flag |= this.modelOverriders.remove((Object)rl) != null;
        }

        public boolean removeFromBlackList(String modid, String itemName) {
            ShapelessRL rl = new ShapelessRL(modid, itemName);
            return this.renderBlackList.remove((Object)rl);
        }

        public List<ShapelessRL> renderBlackList() {
            return new ArrayList<ShapelessRL>(this.renderBlackList);
        }

        public Map<ShapelessRL, IOverriderGetModel> modelOverriders() {
            return new HashMap<ShapelessRL, IOverriderGetModel>(this.modelOverriders);
        }

        public Map<ShapelessRL, IOverriderGetTex> textureOverriders() {
            return new HashMap<ShapelessRL, IOverriderGetTex>(this.textureOverriders);
        }

        public Map<ShapelessRL, IOverriderRender> renderOverriders() {
            return new HashMap<ShapelessRL, IOverriderRender>(this.renderOverriders);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class InitRenderLayersEvent
    extends Event {
        private final Map<Class<? extends IArmRenderLayer>, IArmRenderLayer> renderLayers = new HashMap<Class<? extends IArmRenderLayer>, IArmRenderLayer>();

        public boolean removeLayer(Class<? extends IArmRenderLayer> renderLayer) {
            return this.renderLayers.remove(renderLayer) != null;
        }

        public void addLayerIfModLoad(Class<? extends IArmRenderLayer> renderLayer, String modId) {
            if (Loader.isModLoaded((String)modId)) {
                this.addLayer(renderLayer);
            }
        }

        public void addLayer(Class<? extends IArmRenderLayer> renderLayer) {
            try {
                System.out.println("Registered render layer: " + renderLayer.getName());
                this.renderLayers.put(renderLayer, renderLayer.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                new RuntimeException("Failed to create an object", e).printStackTrace(System.err);
            }
        }

        public Set<IArmRenderLayer> renderLayers() {
            return new HashSet<IArmRenderLayer>(this.renderLayers.values());
        }
    }
}

