/*
 * Decompiled with CFR 0.152.
 */
package com.artur114.armoredarms.client.core;

import com.artur114.armoredarms.api.ArmoredArmsApi;
import com.artur114.armoredarms.api.IArmRenderLayer;
import com.artur114.armoredarms.api.IModelOnlyArms;
import com.artur114.armoredarms.api.IOverrider;
import com.artur114.armoredarms.api.IOverriderGetModel;
import com.artur114.armoredarms.api.IOverriderGetTex;
import com.artur114.armoredarms.api.IOverriderRender;
import com.artur114.armoredarms.client.util.Function2;
import com.artur114.armoredarms.client.util.MiscUtils;
import com.artur114.armoredarms.client.util.RMException;
import com.artur114.armoredarms.client.util.ShapelessRL;
import com.artur114.armoredarms.main.AAConfig;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmRenderLayerArmor
implements IArmRenderLayer {
    public static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public final DefaultTextureGetter defaultTextureGetter = new DefaultTextureGetter();
    public final DefaultModelGetter defaultModelGetter = new DefaultModelGetter();
    public List<LayerRenderer<AbstractClientPlayer>> layerRenderers = null;
    public Map<ShapelessRL, IOverriderGetModel> modelOverriders = null;
    public Map<ShapelessRL, IOverriderGetTex> textureOverriders = null;
    public Map<ShapelessRL, IOverriderRender> renderOverriders = null;
    public final DefaultRender defaultRender = new DefaultRender();
    public final Minecraft mc = Minecraft.func_71410_x();
    public List<ShapelessRL> renderBlackList = null;
    public Set<Item> killingArmor = new HashSet<Item>();
    public LayerBipedArmor armorLayer = null;
    public RenderPlayer renderPlayer = null;
    public boolean render = false;
    public ItemStack chestPlate = null;
    public ItemArmor chestPlateItem = null;
    public IModelOnlyArms currentArmorModel = null;
    public ResourceLocation currentArmorTex = null;
    public ResourceLocation currentArmorTexOv = null;
    public IOverriderGetTex currentGetTexOverrider = null;
    public IOverriderRender currentRenderOverrider = null;
    public IOverriderGetModel currentGetModelOverrider = null;

    @Override
    public void update(AbstractClientPlayer player) {
        try {
            this.tryTick(player);
        }
        catch (RMException rm) {
            this.render = false;
            this.killingArmor.add((Item)this.chestPlateItem);
            throw rm.setMessage("armoredarms.error.layer.armor");
        }
        catch (Throwable tr) {
            this.render = false;
            this.killingArmor.add((Item)this.chestPlateItem);
            throw new RMException(tr).setMessage("armoredarms.error.layer.armor");
        }
    }

    @Override
    public void renderTransformed(AbstractClientPlayer player, EnumHandSide handSide) {
        try {
            this.tryRender(player, handSide);
        }
        catch (RMException rm) {
            this.render = false;
            this.killingArmor.add((Item)this.chestPlateItem);
            throw rm.setMessage("armoredarms.error.layer.armor");
        }
        catch (Throwable tr) {
            this.render = false;
            this.killingArmor.add((Item)this.chestPlateItem);
            throw new RMException(tr).setMessage("armoredarms.error.layer.armor");
        }
    }

    @Override
    public boolean needRender(AbstractClientPlayer player, boolean renderManagerState) {
        return this.render;
    }

    @Override
    public void init(AbstractClientPlayer player) {
        this.renderPlayer = this.initRenderPlayer(player);
        this.layerRenderers = this.initLayerRenderers(player);
        this.armorLayer = this.findArmorLayer();
        this.initEvent();
    }

    public void tryTick(AbstractClientPlayer player) {
        ItemStack chestPlate = this.itemStackArmor(player);
        if (this.killingArmor.contains(chestPlate.func_77973_b()) || !(chestPlate.func_77973_b() instanceof ItemArmor)) {
            this.chestPlate = ItemStack.field_190927_a;
            this.chestPlateItem = null;
            this.render = false;
            return;
        }
        if (this.checkIsNotNew(chestPlate)) {
            return;
        }
        if (this.renderBlackList.contains((Object)new ShapelessRL(chestPlate.func_77973_b().getRegistryName()))) {
            this.chestPlateItem = (ItemArmor)chestPlate.func_77973_b();
            this.chestPlate = chestPlate;
            this.render = false;
            return;
        }
        this.render = true;
        this.chestPlate = chestPlate;
        this.chestPlateItem = (ItemArmor)chestPlate.func_77973_b();
        this.updateOverriders();
        this.currentArmorModel = this.getArmorModel(player);
        this.currentArmorTexOv = this.getArmorTex(player, IOverriderGetTex.EnumTexType.OVERLAY);
        this.currentArmorTex = this.getArmorTex(player, IOverriderGetTex.EnumTexType.NULL);
    }

    public void tryRender(AbstractClientPlayer player, EnumHandSide handSide) {
        ResourceLocation armorTexOv = this.currentArmorTexOv;
        IModelOnlyArms armorModel = this.currentArmorModel;
        ResourceLocation armorTex = this.currentArmorTex;
        this.render(armorModel, armorTexOv, handSide, IOverriderRender.EnumRenderType.ARMOR_OVERLAY);
        this.render(armorModel, armorTex, handSide, IOverriderRender.EnumRenderType.ARMOR);
        this.render(armorModel, ENCHANTED_ITEM_GLINT_RES, handSide, IOverriderRender.EnumRenderType.ARMOR_ENCHANT);
    }

    public ItemStack itemStackArmor(AbstractClientPlayer player) {
        if (Loader.isModLoaded((String)"cosmeticarmorreworked")) {
            int chestId;
            CAStacksBase stacks = CosArmorAPI.getCAStacksClient((UUID)player.func_110124_au());
            if (stacks.isSkinArmor(chestId = EntityEquipmentSlot.CHEST.func_188454_b())) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = stacks.getStackInSlot(chestId);
            if (!stack.func_190926_b()) {
                return stack;
            }
        }
        return player.func_184582_a(EntityEquipmentSlot.CHEST);
    }

    private void initEvent() {
        ArmoredArmsApi.InitArmorRenderLayerEvent event = new ArmoredArmsApi.InitArmorRenderLayerEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.textureOverriders = event.textureOverriders();
        this.renderOverriders = event.renderOverriders();
        this.modelOverriders = event.modelOverriders();
        this.renderBlackList = event.renderBlackList();
    }

    public List<LayerRenderer<AbstractClientPlayer>> initLayerRenderers(AbstractClientPlayer player) {
        try {
            Field[] fields;
            AccessibleObject field = null;
            for (Field rField : fields = RenderLivingBase.class.getDeclaredFields()) {
                boolean isAcc = rField.isAccessible();
                rField.setAccessible(true);
                if (rField.get(this.renderPlayer) instanceof List) {
                    field = rField;
                }
                rField.setAccessible(isAcc);
            }
            if (field == null) {
                throw new RMException("layerRenderers is not find!").setFatalLayer(this);
            }
            boolean isAcc = field.isAccessible();
            ((Field)field).setAccessible(true);
            List layers = (List)((Field)field).get(this.renderPlayer);
            ((Field)field).setAccessible(isAcc);
            return layers;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public LayerBipedArmor findArmorLayer() {
        for (LayerRenderer<AbstractClientPlayer> layerRenderer : this.layerRenderers) {
            if (!(layerRenderer instanceof LayerBipedArmor)) continue;
            return (LayerBipedArmor)layerRenderer;
        }
        throw new IllegalStateException();
    }

    public RenderPlayer initRenderPlayer(AbstractClientPlayer player) {
        return (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)player);
    }

    public void updateOverriders() {
        ShapelessRL rl = new ShapelessRL(this.chestPlateItem.getRegistryName());
        AtomicReference<IOverriderRender> overriderRender = new AtomicReference<IOverriderRender>(this.renderOverriders.get((Object)rl));
        AtomicReference<IOverriderGetTex> overriderGetTex = new AtomicReference<IOverriderGetTex>(this.textureOverriders.get((Object)rl));
        AtomicReference<IOverriderGetModel> overriderGetModel = new AtomicReference<IOverriderGetModel>(this.modelOverriders.get((Object)rl));
        this.findOverrider(overriderRender, this.renderOverriders, rl);
        this.findOverrider(overriderGetTex, this.textureOverriders, rl);
        this.findOverrider(overriderGetModel, this.modelOverriders, rl);
        if (overriderRender.get() == null) {
            overriderRender.set(this.defaultRender);
        }
        if (overriderGetTex.get() == null) {
            overriderGetTex.set(this.defaultTextureGetter);
        }
        if (overriderGetModel.get() == null) {
            overriderGetModel.set(this.defaultModelGetter);
        }
        this.currentRenderOverrider = overriderRender.get();
        this.currentGetTexOverrider = overriderGetTex.get();
        this.currentGetModelOverrider = overriderGetModel.get();
    }

    public <T extends IOverrider> void findOverrider(AtomicReference<T> overrider, Map<ShapelessRL, T> map, ShapelessRL rl) {
        if (overrider.get() == null) {
            map.forEach((k, v) -> {
                if (k.equals((Object)rl)) {
                    if (k.isAbsoluteShapeless() && overrider.get() != null) {
                        return;
                    }
                    overrider.set(v);
                }
            });
        }
    }

    public boolean checkIsNotNew(ItemStack stack) {
        if (AAConfig.useCheckByItem) {
            return stack.func_77973_b() == this.chestPlateItem;
        }
        return stack == this.chestPlate;
    }

    public void render(IModelOnlyArms arms, ResourceLocation tex, EnumHandSide handSide, IOverriderRender.EnumRenderType type) {
        this.currentRenderOverrider.render(arms, tex, handSide, this.chestPlate, this.chestPlateItem, type);
    }

    public IModelOnlyArms getArmorModel(AbstractClientPlayer player) {
        return this.currentGetModelOverrider.getModel(player, this.chestPlateItem, this.chestPlate);
    }

    public ResourceLocation getArmorTex(AbstractClientPlayer player, IOverriderGetTex.EnumTexType type) {
        return this.currentGetTexOverrider.getTexture(player, this.armorLayer, this.layerRenderers, this.chestPlate, this.chestPlateItem, type);
    }

    public static class DefaultModelOnlyArms
    implements IModelOnlyArms {
        public final ModelRenderer[] arms;
        public final ModelBiped mb;

        public DefaultModelOnlyArms(ModelBiped mb) {
            this.arms = new ModelRenderer[]{mb.field_178724_i, mb.field_178723_h};
            this.mb = mb;
        }

        public DefaultModelOnlyArms(ModelBiped mb, Function2<ModelBiped, EnumHandSide, ModelRenderer> armsExtractor) {
            this.arms = new ModelRenderer[]{armsExtractor.apply(mb, EnumHandSide.LEFT), armsExtractor.apply(mb, EnumHandSide.RIGHT)};
            this.mb = mb;
        }

        public DefaultModelOnlyArms(ModelBiped mb, ModelRenderer right, ModelRenderer left) {
            this.arms = new ModelRenderer[]{left, right};
            this.mb = mb;
        }

        @Override
        public void renderArm(AbstractClientPlayer player, ItemArmor itemArmor, ItemStack stackArmor, EnumHandSide side) {
            ModelRenderer arm = this.arms[side.ordinal()];
            arm.field_78795_f = 0.0f;
            arm.field_78796_g = 0.0f;
            arm.field_78808_h = 0.1f * (float)MiscUtils.handSideDelta(side);
            boolean h = arm.field_78807_k;
            boolean s = arm.field_78806_j;
            arm.field_78807_k = false;
            arm.field_78806_j = true;
            arm.func_78785_a(0.0625f);
            arm.field_78807_k = h;
            arm.field_78806_j = s;
        }

        @Override
        public ModelBiped original() {
            return this.mb;
        }
    }

    public static class DefaultTextureGetter
    implements IOverriderGetTex {
        @Override
        public ResourceLocation getTexture(AbstractClientPlayer player, LayerBipedArmor armorLayer, List<LayerRenderer<AbstractClientPlayer>> layerRenderers, ItemStack chestPlate, ItemArmor itemArmor, IOverriderGetTex.EnumTexType type) {
            switch (type) {
                case NULL: {
                    return armorLayer.getArmorResource((Entity)player, chestPlate, EntityEquipmentSlot.CHEST, null);
                }
                case OVERLAY: {
                    if (!itemArmor.hasOverlay(chestPlate)) break;
                    return armorLayer.getArmorResource((Entity)player, chestPlate, EntityEquipmentSlot.CHEST, "overlay");
                }
            }
            return null;
        }
    }

    public static class DefaultModelGetter
    implements IOverriderGetModel {
        private ModelBiped defaultModel = new ModelBiped((float)AAConfig.vanillaArmorModelSize);
        private Function2<ModelBiped, EnumHandSide, ModelRenderer> extractor;
        private double modelSize = AAConfig.vanillaArmorModelSize;
        private Function<ModelBiped, IModelOnlyArms> factory;

        public DefaultModelGetter() {
            this.extractor = (modelBase, handSide) -> {
                switch (handSide) {
                    case RIGHT: {
                        return modelBase.field_178723_h;
                    }
                    case LEFT: {
                        return modelBase.field_178724_i;
                    }
                }
                return null;
            };
            this.factory = modelBiped -> new DefaultModelOnlyArms((ModelBiped)modelBiped, this.extractor());
        }

        @Override
        public IModelOnlyArms getModel(AbstractClientPlayer player, ItemArmor itemArmor, ItemStack stack) {
            ModelBiped mb = itemArmor.getArmorModel((EntityLivingBase)player, stack, EntityEquipmentSlot.CHEST, this.defaultModel);
            if (mb == null) {
                if (this.modelSize != AAConfig.vanillaArmorModelSize) {
                    this.defaultModel = new ModelBiped((float)AAConfig.vanillaArmorModelSize);
                    this.modelSize = AAConfig.vanillaArmorModelSize;
                }
                mb = this.defaultModel;
            }
            return this.factory.apply(mb);
        }

        private Function2<ModelBiped, EnumHandSide, ModelRenderer> extractor() {
            return this.extractor;
        }

        protected void setArmsExtractor(Function2<ModelBiped, EnumHandSide, ModelRenderer> extractor) {
            this.extractor = extractor;
        }

        protected void setFactory(Function<ModelBiped, IModelOnlyArms> factory) {
            this.factory = factory;
        }
    }

    public static class DefaultRender
    implements IOverriderRender {
        private final Minecraft mc = Minecraft.func_71410_x();

        @Override
        public void render(IModelOnlyArms arms, ResourceLocation tex, EnumHandSide handSide, ItemStack stackArmor, ItemArmor itemArmor, IOverriderRender.EnumRenderType type) {
            if (arms == null || tex == null) {
                return;
            }
            switch (type) {
                case ARMOR_ENCHANT: {
                    this.renderEnchant(arms, tex, stackArmor, itemArmor, handSide);
                    break;
                }
                case ARMOR: {
                    this.renderArmor(arms, tex, stackArmor, itemArmor, handSide);
                    break;
                }
                case ARMOR_OVERLAY: {
                    this.render(arms, tex, stackArmor, itemArmor, handSide);
                }
            }
        }

        private void renderArmor(IModelOnlyArms arms, ResourceLocation tex, ItemStack stackArmor, ItemArmor itemArmor, EnumHandSide handSide) {
            if (itemArmor.hasOverlay(stackArmor)) {
                int i = itemArmor.func_82814_b(stackArmor);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
                this.render(arms, tex, stackArmor, itemArmor, handSide);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                this.render(arms, tex, stackArmor, itemArmor, handSide);
            }
        }

        private void render(IModelOnlyArms arms, ResourceLocation tex, ItemStack stackArmor, ItemArmor itemArmor, EnumHandSide handSide) {
            this.mc.func_110434_K().func_110577_a(tex);
            arms.renderArm((AbstractClientPlayer)this.mc.field_71439_g, itemArmor, stackArmor, handSide);
        }

        private void renderEnchant(IModelOnlyArms arms, ResourceLocation tex, ItemStack stackArmor, ItemArmor itemArmor, EnumHandSide handSide) {
            if (!stackArmor.func_77962_s()) {
                return;
            }
            float f = this.mc.field_71439_g.field_70173_aa;
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            this.mc.func_110434_K().func_110577_a(tex);
            this.mc.field_71460_t.func_191514_d(true);
            GlStateManager.func_179147_l();
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            for (int i = 0; i < 2; ++i) {
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179152_a((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
                GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
                GlStateManager.func_179128_n((int)5888);
                arms.renderArm((AbstractClientPlayer)this.mc.field_71439_g, itemArmor, stackArmor, handSide);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179084_k();
            this.mc.field_71460_t.func_191514_d(false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        }
    }
}

