/*
 * Decompiled with CFR 0.152.
 */
package com.artur114.armoredarms.client.core;

import com.artur114.armoredarms.api.ArmoredArmsApi;
import com.artur114.armoredarms.api.IArmRenderLayer;
import com.artur114.armoredarms.client.core.ArmRenderLayerArmor;
import com.artur114.armoredarms.client.core.ArmRenderLayerVanilla;
import com.artur114.armoredarms.client.util.RMException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderArmManager {
    public static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    public final Minecraft mc = Minecraft.func_71410_x();
    public Set<IArmRenderLayer> renderLayers = null;
    public boolean initTick = true;
    public boolean render = false;
    public boolean died = false;

    public void renderSpecificHandEvent(RenderSpecificHandEvent e) {
        if (this.died || !this.render) {
            return;
        }
        try {
            this.tryRender(e);
        }
        catch (RMException rm) {
            this.onException(rm.setMethod(RMException.Method.RENDER));
        }
        catch (Throwable exp) {
            this.onException(new RMException(exp).setMethod(RMException.Method.RENDER));
        }
    }

    public void tickEventClientTickEvent(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.START || this.mc.field_71439_g == null || this.mc.func_147113_T() || this.died) {
            return;
        }
        try {
            this.tryTick(e);
        }
        catch (RMException rm) {
            this.onException(rm.setMethod(RMException.Method.TICK));
        }
        catch (Throwable exp) {
            this.onException(new RMException(exp).setMethod(RMException.Method.TICK));
        }
    }

    public void tryRender(RenderSpecificHandEvent e) {
        EntityPlayerSP player = this.mc.field_71439_g;
        EnumHandSide enumhandside = e.getHand() == EnumHand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        float interpPitch = e.getInterpolatedPitch();
        float swingProgress = e.getSwingProgress();
        float equipProgress = e.getEquipProgress();
        ItemStack stack = e.getItemStack();
        EnumHand hand = e.getHand();
        GlStateManager.func_179094_E();
        boolean flag = false;
        if (stack.func_190926_b()) {
            if (hand == EnumHand.MAIN_HAND) {
                this.renderArmFirstPerson(equipProgress, swingProgress, enumhandside);
                flag = true;
            }
        } else if (stack.func_77973_b() instanceof ItemMap) {
            if (hand == EnumHand.MAIN_HAND && player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                this.renderMapFirstPerson(interpPitch, equipProgress, swingProgress, stack);
            } else {
                this.renderMapFirstPersonSide(equipProgress, enumhandside, swingProgress, stack);
            }
            flag = true;
        }
        if (flag) {
            e.setCanceled(true);
        }
        GlStateManager.func_179121_F();
    }

    public void tryTick(TickEvent.ClientTickEvent e) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (this.initTick) {
            try {
                this.init((AbstractClientPlayer)player);
                this.initTick = false;
            }
            catch (Throwable exp) {
                throw new RMException("It was not possible to load RenderArmManager, custom hands will not be rendered!", exp).setFatal();
            }
        }
        boolean render = false;
        for (IArmRenderLayer layer : this.renderLayers) {
            try {
                layer.update((AbstractClientPlayer)player);
            }
            catch (RMException rm) {
                throw rm;
            }
            catch (Throwable tr) {
                throw new RMException(tr).setFatalLayer(layer);
            }
            render |= layer.needRender((AbstractClientPlayer)player, render);
        }
        this.render = render;
    }

    public void init(AbstractClientPlayer player) {
        ArmoredArmsApi.InitRenderLayersEvent event = new ArmoredArmsApi.InitRenderLayersEvent();
        event.addLayer(ArmRenderLayerVanilla.class);
        event.addLayer(ArmRenderLayerArmor.class);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.renderLayers = event.renderLayers();
        for (IArmRenderLayer layer : this.renderLayers) {
            try {
                layer.init(player);
            }
            catch (RMException rm) {
                throw rm;
            }
            catch (Throwable tr) {
                throw new RMException(tr).setFatalLayer(layer);
            }
        }
    }

    public void onException(RMException exception) {
        if (exception.isFatal()) {
            this.died = true;
        }
        if (exception.isFatalOnLayer()) {
            this.renderLayers.remove(exception.fatalLayer());
        }
        for (ITextComponent message : exception.messageForPlayer()) {
            this.mc.field_71439_g.func_145747_a(message.func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        exception.printStackTrace(System.err);
    }

    public void renderArms() {
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.transAndRenderArm(EnumHandSide.RIGHT);
        this.transAndRenderArm(EnumHandSide.LEFT);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
    }

    public float getMapAngleFromPitch(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }

    public void transAndRenderArm(EnumHandSide enumHandSide) {
        GlStateManager.func_179094_E();
        float f = enumHandSide == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        this.renderArm((AbstractClientPlayer)this.mc.field_71439_g, enumHandSide);
        GlStateManager.func_179121_F();
    }

    public void renderMapFirstPerson(float interPitch, float equipProgress, float swingProgress, ItemStack stack) {
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        float f3 = this.getMapAngleFromPitch(interPitch);
        GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + equipProgress * -1.2f + f3 * -0.5f), (float)-0.72f);
        GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderArms();
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.renderMapFirstPerson(stack);
    }

    public void renderMapFirstPersonSide(float p_187465_1_, EnumHandSide hand, float p_187465_3_, ItemStack stack) {
        float f = hand == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.func_179109_b((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderArmFirstPerson(p_187465_1_, p_187465_3_, hand);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(f * 0.51f), (float)(-0.08f + p_187465_1_ * -1.2f), (float)-0.75f);
        float f1 = MathHelper.func_76129_c((float)p_187465_3_);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(p_187465_3_ * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
        GlStateManager.func_179114_b((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderMapFirstPerson(stack);
        GlStateManager.func_179121_F();
    }

    public void renderMapFirstPerson(ItemStack stack) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.38f, (float)0.38f, (float)0.38f);
        GlStateManager.func_179140_f();
        this.mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData mapdata = ((ItemMap)stack.func_77973_b()).func_77873_a(stack, (World)this.mc.field_71441_e);
        if (mapdata != null) {
            this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.func_179145_e();
    }

    public void renderArmFirstPerson(float equipProgress, float swingProgress, EnumHandSide enumhandside) {
        float f = enumhandside != EnumHandSide.LEFT ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + equipProgress * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        this.renderArm((AbstractClientPlayer)this.mc.field_71439_g, enumhandside);
        GlStateManager.func_179089_o();
    }

    public void renderArm(AbstractClientPlayer player, EnumHandSide handSide) {
        for (IArmRenderLayer layer : this.renderLayers) {
            if (!layer.needRender(player, this.render)) continue;
            try {
                layer.renderTransformed(player, handSide);
            }
            catch (RMException rm) {
                throw rm;
            }
            catch (Throwable tr) {
                throw new RMException(tr).setFatalLayer(layer);
            }
        }
    }
}

