/*
 * Decompiled with CFR 0.152.
 */
package org.gaycraft.prideflagpoles.versioned;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TallBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;

    public TallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor la, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)la, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, la, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(ctx) ? (BlockState)((BlockState)super.m_5573_(ctx).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(AXIS, (Comparable)Direction.Axis.Y) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        BlockPos blockpos = pos.m_7494_();
        level.m_7731_(blockpos, TallBlock.copyWaterloggedFrom((LevelReader)level, blockpos, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return super.m_7898_(state, levelReader, pos);
        }
        BlockState blockstate = levelReader.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, levelReader, pos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public static void placeAt(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, int i) {
        BlockPos blockpos = blockPos.m_7494_();
        levelAccessor.m_7731_(blockPos, TallBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos, (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)), i);
        levelAccessor.m_7731_(blockpos, TallBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockpos, (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), i);
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos pos, BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(pos))) : state;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                TallBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                TallBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack itemStack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), entity, itemStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = blockPos.m_7495_())).m_60713_(blockState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, blockstate1, 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, AXIS});
    }

    public List<ItemStack> getDrops(BlockState state) {
        return Collections.emptyList();
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_7381_(p_60537_, p_60538_));
        drops.addAll(this.getDrops(p_60537_));
        return drops;
    }

    protected VoxelShape getLowerShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected VoxelShape getUpperShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? this.getLowerShape(state, worldIn, pos, context) : this.getUpperShape(state, worldIn, pos, context);
    }

    public RenderShape getTallRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? RenderShape.INVISIBLE : this.getTallRenderShape(state);
    }
}

