/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.api.datagen;

import gay.sylv.wij.impl.datagen.RuntimeResourcePackImpl;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

import java.io.InputStream;
import java.util.Map;

/**
 * common fabric resource api fail
 * <br>
 * basically just use this for adding resources at runtime or something idk lol.
 * good for when you need to dynamically do resources after all the other mods.
 */
public interface RuntimeResourcePack extends class_3262, ModResourcePack {
	static RuntimeResourcePack getInstance() {
		return RuntimeResourcePackImpl.INSTANCE;
	}
	
	Map<class_2960, String> getItemMcmeta();
	
	void addItemMcmeta(class_2960 id, String mcmetaJson);
	
	Map<class_2960, String> getItemTags();
	
	void addItemTag(class_2960 id, String tagJson);
	
	Map<class_2960, String> getModels();
	
	void addModel(class_2960 id, String modelJson);
	
	Map<class_2960, class_1011> getItemTextures();
	
	void addItemTexture(class_2960 id, class_1011 image);
	
	@Nullable
	class_7367<InputStream> getResource(class_2960 id);
}
