/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.api.entity.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_8792;

/**
 * A collection of extra events missing in {@link net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents}.
 */
public final class ServerPlayerEventsExtra {
	/**
	 * An event that is called after a new player is placed in the world. This event is useful for sending packets using player data.
	 */
	public static final Event<AfterSpawn> AFTER_SPAWN = EventFactory.createArrayBacked(AfterSpawn.class, listeners -> (connection, player,  cookie) -> {
		for (AfterSpawn listener : listeners) {
			listener.afterSpawn(connection, player, cookie);
		}
	});
	
	@FunctionalInterface
	public interface AfterSpawn {
		/**
		 * Called after a new player is placed.
		 * @param connection The player's connection.
		 * @param player The player entity that spawned.
		 * @param cookie The player's cookie.
		 */
		void afterSpawn(class_2535 connection, class_3222 player, class_8792 cookie);
	}
}
