/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.block.item;

import dev.gegy.roles.api.PlayerRolesApi;
import gay.sylv.wij.api.permissions.Permissions;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.component.Components;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.jar.JarEntry;
import gay.sylv.wij.impl.util.jar.JarPlacer;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class WorldJarBlockItem extends class_1747 {
	public WorldJarBlockItem(class_2248 block, class_1793 properties) {
		super(block, properties);
	}
	
	@Override
	public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
		super.method_7851(stack, context, tooltipComponents, tooltipFlag);
		tooltipComponents.add(class_2561.method_43469("tooltip.worldinajar.world_jar.id", stack.method_57825(Components.JAR_ENTRY_TYPE, new JarEntry(-1))));
	}
	
	@Override
	protected boolean method_7709(class_1750 context, class_2680 state) {
		if (!context.method_8045().method_8608()) {
			class_1799 itemInHand = context.method_8041();
			boolean canCreate = Permissions.CREATE_JAR.test(context.method_8036());
			if (!(itemInHand.method_57826(Components.JAR_ENTRY_TYPE) && Objects.requireNonNull(itemInHand.method_57824(Components.JAR_ENTRY_TYPE)).id() > -1) && !canCreate) {
				if (context.method_8036() != null && !context.method_8045().method_8608()) {
					context.method_8036().method_43496(class_2561.method_43470("You do not have permission create new World Jars!"));
				}
				return false;
			}
		}
		
		// Prevent placement in jar dimension
		if (!context.method_8045().method_27983().equals(Dimensions.JAR)) {
			return super.method_7709(context, state);
		} else {
			return false;
		}
	}
	
	@Override
	public class_1750 method_16356(class_1750 context) {
		if (context.method_8045().method_8608()) {
			return context;
		}
		
		class_1799 itemInHand = context.method_8041();
		JarPlacer jarPlacer = JarPlacer.getInstance();
		JarEntry jarEntry;
		if (itemInHand.method_57826(Components.JAR_ENTRY_TYPE) && Objects.requireNonNull(itemInHand.method_57824(Components.JAR_ENTRY_TYPE)).id() > -1) {
			jarEntry = itemInHand.method_57824(Components.JAR_ENTRY_TYPE);
			assert jarEntry != null;
		} else if (Permissions.CREATE_JAR.test(context.method_8036())) {
			jarEntry = jarPlacer.getFreeJarEntry();
			itemInHand.method_57379(Components.JAR_ENTRY_TYPE, jarEntry);
			jarPlacer.placeJar(jarEntry);
		} else {
			return context;
		}
		
		class_2487 tag = new class_2487();
		class_2487 modTag = new class_2487();
		modTag.method_10569("id", jarEntry.id());
		if (context.method_8036() != null && context.method_8036().method_7337()) {
			WorldJarBlockEntity.CONTAINER_LOCK.method_5474(tag);
		}
		tag.method_10566(Constants.COMPAT_MOD_ID, modTag);
		
		class_1747.method_57338(itemInHand, Blocks.WORLD_JAR.type(), tag);
		return context;
	}
}
