/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.client.block.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import gay.sylv.wij.api.block.JarContainmentBlock;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.client.render.JarInternalsRenderer;
import gay.sylv.wij.impl.dimension.Dimensions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_750;
import net.minecraft.class_827;
import net.minecraft.class_9801;
import net.minecraft.client.renderer.*;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

// todo: rewrite this fuckass code
public class WorldJarRenderer implements class_827<WorldJarBlockEntity> {
	private final class_5614.class_5615 context;
	// always reuse the same SectionBufferBuilderPack because it cannot be freed, so it's an instant memory leak.
	private static final class_750 BYTE_BUFFER_BUILDERS = new class_750();
	private static final Map<class_1921, class_287> BUFFERS = new HashMap<>();
	
	public WorldJarRenderer(class_5614.class_5615 context) {
		this.context = context;
	}
	
	@Override
	public void render(
			WorldJarBlockEntity jar,
			float partialTick,
			class_4587 poseStack,
			class_4597 bufferSource,
			int packedLight,
			int packedOverlay
	) {
		if (jar.method_10997() != null && jar.method_10997().method_27983().equals(Dimensions.JAR)) return;
		poseStack.method_22903();
		// prevent z-fighting
		poseStack.method_22905(
				jar.getVisualScale() - 0.001f,
				jar.getVisualScale() - 0.001f,
				jar.getVisualScale() - 0.001f
		);
		poseStack.method_46416(
				0.001f,
				0.001f,
				0.001f
		);
		
		if (jar.statesChanged) {
			jar.statesChanged = false;
			buildJar(context, jar);
		}
		
		renderJar(jar, poseStack);
		poseStack.method_22909();
	}
	
	public static void renderJar(
			WorldJarBlockEntity jar,
			class_4587 poseStack
	) {
		for (class_1921 renderType : class_1921.method_22720()) {
			renderType.method_23516();
			class_5944 shader = RenderSystem.getShader();
			Matrix4f frustumMatrix = poseStack.method_23760().method_23761();
			Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
			matrix4fStack.pushMatrix();
			matrix4fStack.mul(frustumMatrix);
			Matrix4f modelView = new Matrix4f(matrix4fStack);
			
			jar.getChunkSections().forEach((pos, section) -> {
				if (section.isHasBuilt() && section.getRenderedTypes().contains(renderType)) {
					class_291 buffer = section.getVertexBuffers().get(renderType);
					buffer.method_1353();
					buffer.method_34427(modelView, RenderSystem.getProjectionMatrix(), shader);
					class_291.method_1354();
				}
			});
			
			matrix4fStack.popMatrix();
			
			renderType.method_23518();
		}
	}
	
	public static void buildJar(
			class_5614.class_5615 context,
			WorldJarBlockEntity jar
	) {
		class_5819 randomSource = Objects.requireNonNull(jar.method_10997()).method_8409();
		// The sections' PoseStack
		class_4587 poseStack = new class_4587();
		
		jar.getChunkSections().forEach((pos, section) -> {
			class_2338 origin = section.getOrigin();
			class_2338 offset = new class_2338(15, 15, 15).method_10081(origin);
			
			section.getRenderedTypes().clear();
			
			for (class_2338 blockPos : class_2338.method_10097(origin, offset)) {
				class_2680 state = jar.getBlockState(blockPos);
				if (state.method_26204() instanceof JarContainmentBlock containmentBlock && !containmentBlock.renderInJar())
					continue; // Don't render jar container blocks.
				class_3610 fluidState = state.method_26227();
				
				if (state.method_26164(BlockTags.NAUGHTY_BLOCKS)) continue;
				
				if (!fluidState.method_15769()) {
					class_1921 renderType = class_4696.method_23680(fluidState);
					section.getRenderedTypes().add(renderType);
					class_287 bufferBuilder = getOrSetBufferBuilder(renderType);
					
					context.method_32141().method_3352(blockPos, jar.renderChunkRegion, bufferBuilder, state, fluidState);
				}
				
				if (state.method_26217() == class_2464.field_11458) {
					class_1921 renderType = class_4696.method_23679(state);
					section.getRenderedTypes().add(renderType);
					class_287 bufferBuilder = getOrSetBufferBuilder(renderType);
					
					poseStack.method_22903();
					poseStack.method_46416(
							blockPos.method_10263(),
							blockPos.method_10264(),
							blockPos.method_10260()
					);
					context.method_32141().method_3355(state, blockPos, jar.renderChunkRegion, poseStack, bufferBuilder, true, randomSource);
					poseStack.method_22909();
				}
			}
			
			// end building and upload vertex buffers
			for (class_1921 renderType : section.getRenderedTypes()) {
				class_291 buffer = section.getVertexBuffers().get(renderType);
				class_287 bufferBuilder = BUFFERS.get(renderType);
				class_9801 renderedBuffer = bufferBuilder.method_60794();
				buffer.method_1353();
				buffer.method_1352(renderedBuffer);
				class_291.method_1354();
			}
			
			// flush buffers
			BUFFERS.clear();
			section.setHasBuilt(true);
		});
	}
	
	private static class_287 getOrSetBufferBuilder(class_1921 renderType) {
		return JarInternalsRenderer.getOrSetBufferBuilder(renderType, BUFFERS, BYTE_BUFFER_BUILDERS);
	}
}
