/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.client.render;

import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.function.BiConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_8527;
import net.minecraft.class_8528;

/**
 * A full version of {@link JarLevelChunkSection}. This is used in lighting.
 * @author sylv
 */
public class JarChunk implements class_8527 {
	private final class_1923 offset;
	private final WorldJarBlockEntity jar;
	private final Long2ObjectMap<class_2586> blockEntities = new Long2ObjectOpenHashMap<>(); // TODO: implement BEs and BERs
	private final class_8528 chunkSkyLightSources;
	
	/**
	 * @param offset The position of the chunk.
	 */
	public JarChunk(class_1923 offset, WorldJarBlockEntity jar) {
		this.offset = offset;
		this.jar = jar;
		this.chunkSkyLightSources = new class_8528(this);
	}
	
	@Override
	public int method_31605() {
		return jar.getScale();
	}
	
	@Override
	public int method_31607() {
		return 0;
	}
	
	@Override
	public class_2586 method_8321(class_2338 pos) {
		return blockEntities.get(pos.method_10063());
	}
	
	@Override
	public @NotNull class_2680 method_8320(class_2338 pos) {
		class_4076 chunkPos = class_4076.method_18676(offset.field_9181, class_4076.method_32204(pos.method_10264()), offset.field_9180);
		return jar.getChunkSections().get(chunkPos.method_18694()).getBlockState(pos.method_10263() & 15, pos.method_10264() & 15, pos.method_10260() & 15);
	}
	
	@Override
	public @NotNull class_3610 method_8316(class_2338 pos) {
		return method_8320(pos).method_26227();
	}
	
	@Override
	public void method_51524(BiConsumer<class_2338, class_2680> callback) {
		java.util.function.Predicate<class_2680> illuminates = state -> state.method_26213() != 0;
		class_2338.class_2339 blockPos = new class_2338.class_2339();
		for (int i = 0; i < jar.getChunkDiameter(); i++) {
			JarLevelChunkSection section = getSection(i);
			if (section.maybeHas(illuminates)) {
				for (int x = 0; x <= 15; x++) {
					for (int y = 0; y <= 15; y++) {
						for (int z = 0; z <= 15; z++) {
							class_2680 state = section.getBlockState(x, y, z);
							if (illuminates.test(state)) {
								callback.accept(blockPos.method_25504(section.getOrigin(), x, y, z), state);
							}
						}
					}
				}
			}
		}
	}
	
	@Override
	public @NotNull class_8528 method_12018() {
		return chunkSkyLightSources;
	}
	
	private JarLevelChunkSection getSection(int y) {
		class_4076 chunkPos = class_4076.method_18676(offset.field_9181, y, offset.field_9180);
		return jar.getChunkSections().get(chunkPos.method_18694());
	}
}


