/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.client.render;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import java.lang.ref.Cleaner;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * A 16x16x16 sub-chunk. This uses VBOs for rendering.
 * @author sylv
 */
public class JarLevelChunkSection {
	/**
	 * The bottom-south-west corner of the chunk. <b>Note</b>: This is automatically aligned to a 16x16x16 grid.
	 */
	private final class_2338 origin;
	@SuppressWarnings({"FieldCanBeLocal", "unused"})
	@Environment(EnvType.CLIENT)
	private Cleaner.Cleanable cleanable;
	@Environment(EnvType.CLIENT)
	private Map<class_1921, class_291> vertexBuffers;
	@Environment(EnvType.CLIENT)
	private ReferenceArraySet<class_1921> renderedTypes;
	private boolean hasBuilt = false;
	private class_2841<class_2680> blockStates;
	
	private static final Cleaner CLEANER = Cleaner.create();
	
	/**
	 * @param offset The position of the chunk in 3-dimensions.
	 */
	public JarLevelChunkSection(class_4076 offset, boolean isClient) {
		this(
				offset,
				isClient,
				// set empty BlockState container
				new class_2841<>(
						class_2248.field_10651,
						net.minecraft.class_2246.field_10124.method_9564(),
						class_2841.class_6563.field_34569
				)
		);
	}
	
	/**
	 * @param offset The position of the chunk in 3-dimensions.
	 */
	public JarLevelChunkSection(class_4076 offset, boolean isClient, class_2841<class_2680> blockStates) {
		origin = new class_2338(offset.method_35862(16));
		this.blockStates = blockStates;
		if (isClient) {
			vertexBuffers = class_1921.method_22720().stream()
					.collect(
							Collectors.toMap(
									key -> key,
									renderType -> new class_291(class_291.class_8555.field_44793)
							)
					);
			this.cleanable = CLEANER.register(this, new ClientClean(vertexBuffers));
			this.renderedTypes = new ReferenceArraySet<>(class_1921.method_22720().size());
		}
	}
	
	/**
	 * Determines if any {@link class_2680}s adhere to the predicate.
	 * @author sylv
	 */
	public boolean maybeHas(Predicate<class_2680> predicate) {
		return blockStates.method_19526(predicate);
	}
	
	/**
	 * @return the {@link class_2680} at the given {@link class_2338}.
	 * @author sylv
	 */
	public class_2680 getBlockState(int x, int y, int z) {
		return blockStates.method_12321(x, y, z);
	}
	
	public void setBlockState(int x, int y, int z, class_2680 state) {
		blockStates.method_35321(x, y, z, state);
	}
	
	public boolean isHasBuilt() {
		return hasBuilt;
	}
	
	public void setHasBuilt(boolean hasBuilt) {
		this.hasBuilt = hasBuilt;
	}
	
	@Environment(EnvType.CLIENT)
	public ReferenceArraySet<class_1921> getRenderedTypes() {
		return renderedTypes;
	}
	
	@Environment(EnvType.CLIENT)
	public void setRenderedTypes(ReferenceArraySet<class_1921> renderedTypes) {
		this.renderedTypes = renderedTypes;
	}
	
	@Environment(EnvType.CLIENT)
	public Map<class_1921, class_291> getVertexBuffers() {
		return vertexBuffers;
	}
	
	public class_2338 getOrigin() {
		return origin;
	}
	
	public void setBlockStates(class_2841<class_2680> blockStates) {
		this.blockStates = blockStates;
	}
	
	public class_2841<class_2680> getBlockStates() {
		return this.blockStates;
	}
	
	/**
	 * Prevents memory leaks by closing {@link class_291}s.
	 *
	 * @author SoniEx2
	 */
	@Environment(EnvType.CLIENT)
	private record ClientClean(Map<class_1921, class_291> vertexBuffers) implements Runnable {
		@Override
		public void run() {
			class_310.method_1551().execute(() -> {
				vertexBuffers.values().forEach(class_291::close);
			});
		}
	}
}
