/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.client.render;

import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.util.Conversions;
import gay.sylv.wij.impl.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4700;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_8527;

/**
 * A {@link net.minecraft.class_1920} for {@link JarLevelChunkSection}s.
 * TODO: use the entity world's lighting
 * @author sylv
 */
public class JarRenderChunkRegion implements class_1920 {
	/**
	 * A cache of biome colors for calculating biome color.
	 */
	private final Map<class_6539, class_4700> tintCache = createTintCache(class_1163.field_5665, class_1163.field_5664, class_1163.field_5666);
	private final WorldJarBlockEntity jar;
	private final JarLevelLightEngine lightEngine;
	
	public JarRenderChunkRegion(WorldJarBlockEntity jar, JarLevelLightEngine lightEngine) {
		this.jar = jar;
		this.lightEngine = lightEngine;
	}
	
	public static Map<class_6539, class_4700> createTintCache(class_6539... resolver) {
		var map = new HashMap<class_6539, class_4700>();
		Arrays.stream(resolver)
				.map(x -> Pair.of(x, new class_4700(pos -> calculateColor(pos, x))))
				.forEach(pair -> map.put(pair.first(), pair.second()));
		return map;
	}
	
	@Override
	public float method_24852(class_2350 direction, boolean shade) {
		return Objects.requireNonNull(jar.method_10997()).method_24852(direction, shade);
	}
	
	@Override
	public @NotNull class_3568 method_22336() {
		return lightEngine;
	}
	
	@Override
	public int method_23752(class_2338 pos, class_6539 colorResolver) {
		return tintCache.get(colorResolver).method_23770(pos);
	}
	
	@Nullable
	@Override
	public class_2586 method_8321(class_2338 pos) {
		class_1923 chunkPos = Conversions.convert(pos);
		class_8527 chunk = jar.getChunk(chunkPos.field_9181, chunkPos.field_9180);
		return chunk != null ? chunk.method_8321(pos) : null;
	}
	
	@Override
	public @NotNull class_2680 method_8320(class_2338 pos) {
		return jar.getBlockState(pos);
	}
	
	@Override
	public @NotNull class_3610 method_8316(class_2338 pos) {
		return jar.getFluidState(pos);
	}
	
	@Override
	public int method_31605() {
		return jar.getScale();
	}
	
	@Override
	public int method_31607() {
		return -64;
	}
	
	/**
	 * This calls {@link class_638#method_23780}.
	 * @author sylv
	 */
	public static int calculateColor(class_2338 pos, class_6539 colorProvider) {
		var client = class_310.method_1551();
		assert client.field_1687 != null;
		return client.field_1687.method_23780(pos, colorProvider);
	}
}
