/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.component;

import gay.sylv.wij.impl.util.Initializable;
import gay.sylv.wij.impl.util.jar.JarEntry;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

import static gay.sylv.wij.impl.util.Constants.modId;

public final class Components implements Initializable {
	public static final Components INSTANCE = new Components();
	
	public static class_9331<JarEntry> JAR_ENTRY_TYPE;
	
	private Components() {}
	
	@Override
	public void initialize() {
		JAR_ENTRY_TYPE = register(
				"jar_entry",
				class_9331.<JarEntry>method_57873()
						.method_57881(JarEntry.CODEC)
						.method_57880()
		);
	}
	
	private static <T> class_9331<T> register(String name, class_9331<T> type) {
		return class_2378.method_10230(
				class_7923.field_49658,
				modId(name),
				type
		);
	}
}
