/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.datagen;

import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.item.Items;
import gay.sylv.wij.impl.item.tag.ItemTags;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1856;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8074;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public final class DataGenerator implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator generator) {
		FabricDataGenerator.Pack pack = generator.createPack();
		pack.addProvider(BlockTagGenerator::new);
		pack.addProvider(ItemTagGenerator::new);
		pack.addProvider(BlockLootTableGenerator::new);
		pack.addProvider(RecipeGenerator::new);
	}
	
	private static final class BlockTagGenerator extends FabricTagProvider.BlockTagProvider {
		public BlockTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}
		
		@Override
		protected void method_10514(class_7225.class_7874 wrapperLookup) {
			getOrCreateTagBuilder(net.minecraft.class_3481.field_33715)
					.add(Blocks.WORLD_JAR.block())
					.add(Blocks.SUSSYSTONE.block())
					.add(net.minecraft.class_2246.field_9987);
			
			getOrCreateTagBuilder(net.minecraft.class_3481.field_33718)
					.add(Blocks.WORLD_JAR.block())
					.add(Blocks.SUSSYSTONE.block());
			getOrCreateTagBuilder(BlockTags.NEEDS_BEDROCK_TOOL)
					.add(net.minecraft.class_2246.field_9987);
			
			getOrCreateTagBuilder(BlockTags.UNBREAKABLE)
					.add(net.minecraft.class_2246.field_9987);
			
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49930)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49928)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49927)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49929)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49926)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(net.minecraft.class_3481.field_49925)
					.method_26792(BlockTags.NEEDS_BEDROCK_TOOL);
			getOrCreateTagBuilder(BlockTags.INCORRECT_FOR_BEDROCK_TOOL);
			
			getOrCreateTagBuilder(BlockTags.NAUGHTY_BLOCKS)
					.method_35922(class_2960.method_60655("affinity", "the_sky"));
		}
	}
	
	private static final class ItemTagGenerator extends FabricTagProvider.ItemTagProvider {
		public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
			super(output, completableFuture);
		}
		
		@Override
		protected void method_10514(class_7225.class_7874 wrapperLookup) {
			getOrCreateTagBuilder(ItemTags.DESTROYS_UNBREAKABLE)
					.add(Items.BEDROCK_PICKAXE);
			
			getOrCreateTagBuilder(ItemTags.CHIPS_UNBREAKABLE)
					.add(net.minecraft.class_1802.field_22024);
			
			getOrCreateTagBuilder(ItemTags.CHIPS_OR_DESTROYS_UNBREAKABLE)
					.method_26792(ItemTags.DESTROYS_UNBREAKABLE)
					.method_26792(ItemTags.CHIPS_UNBREAKABLE);
			
			getOrCreateTagBuilder(net.minecraft.class_3489.field_42614)
					.add(Items.BEDROCK_PICKAXE);
		}
	}
	
	private static final class BlockLootTableGenerator extends FabricBlockLootTableProvider {
		public BlockLootTableGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
			super(dataOutput, registryLookup);
		}
		
		@Override
		public void method_10379() {
			method_46025(Blocks.CORK_BLOCK.block());
			method_46025(Blocks.WORLD_JAR.block());
		}
	}
	
	private static final class RecipeGenerator extends FabricRecipeProvider {
		
		public RecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
			super(output, registriesFuture);
		}
		
		@Override
		public void method_10419(class_8790 exporter) {
			class_2447
					.method_10437(class_7800.field_40642, Blocks.WORLD_JAR.item())
					.method_10429("has_ender_eye", method_10426(net.minecraft.class_1802.field_8449))
					.method_10429("has_reinforced_echnoplast", method_10426(Blocks.REINFORCED_ECHNOPLAST.item()))
					.method_10429("has_cork_block", method_10426(Blocks.CORK_BLOCK.item()))
					.method_10434('o', net.minecraft.class_1802.field_8449)
					.method_10434('O', Blocks.REINFORCED_ECHNOPLAST.item())
					.method_10434('#', Blocks.CORK_BLOCK.item())
					.method_10439("O#O")
					.method_10439("OoO")
					.method_10439("OOO")
					.method_10431(exporter);
			class_2447.method_10437(class_7800.field_40642, Blocks.CORK_BLOCK.item())
					.method_10429("has_bark", method_10420(ItemTags.BARK))
					.method_10433('/', ItemTags.BARK)
					.method_10439("///")
					.method_10439("///")
					.method_10439("///")
					.method_10431(exporter);
			class_2447.method_10437(class_7800.field_40642, Blocks.REINFORCED_ECHNOPLAST.item())
					.method_10429("has_bedrock_shard", method_10426(Items.BEDROCK_SHARD))
					.method_10429("has_amethyst_shard", method_10426(net.minecraft.class_1802.field_27063))
					.method_10434('%', Items.BEDROCK_SHARD)
					.method_10434('/', net.minecraft.class_1802.field_27063)
					.method_10434('O', net.minecraft.class_1802.field_8280)
					.method_10439("%/%")
					.method_10439("/O/")
					.method_10439("%/%")
					.method_10431(exporter);
			class_8074.method_48535(
					class_1856.method_8091(net.minecraft.class_1802.field_41946),
					class_1856.method_8091(net.minecraft.class_1802.field_22024),
					class_1856.method_8091(Items.BEDROCK_SHARD),
					class_7800.field_40638,
					Items.BEDROCK_PICKAXE
			)
					.method_48536("has_bedrock_shard", method_10426(Items.BEDROCK_SHARD))
					.method_48536("has_netherite_pickaxe", method_10426(net.minecraft.class_1802.field_22024))
					.method_48537(exporter, class_7923.field_41178.method_10221(Items.BEDROCK_PICKAXE));
		}
	}
}
