/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gay.sylv.wij.api.datagen.RuntimeResourcePack;
import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.Conversions;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3288;
import net.minecraft.class_4239;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7654;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.server.packs.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.*;
import java.util.stream.Collectors;

public class RuntimeResourcePackImpl implements RuntimeResourcePack, class_3262, ModResourcePack {
	public static final RuntimeResourcePackImpl INSTANCE = new RuntimeResourcePackImpl();
	public static final String PACK_ID = Constants.COMPAT_MOD_ID + "_rrp";
	public static final class_9225 BUILT_IN_SELECTION_CONFIG = new class_9225(true, class_3288.class_3289.field_14280, false);
	public static final class_3288.class_7680 FIXED_RESOURCES = fixedResources();
	
	private static final class_9224 LOCATION = new class_9224(PACK_ID, class_2561.method_43470(Constants.MOD_NAME + " RRP"), class_5352.field_25348, Optional.empty());
	private static final Map<class_2960, class_1011> ITEM_TEXTURES = new HashMap<>();
	private static final Map<class_2960, String> ITEM_TEXTURE_MCMETA = new HashMap<>();
	private static final Map<class_2960, String> MODELS = new HashMap<>();
	private static final Map<class_2960, String> ITEM_TAGS = new HashMap<>();
	private static final class_7654 ITEM_PNG_LISTER = new class_7654("textures/item", ".png");
	private static final class_7654 ITEM_PNG_MCMETA_LISTER = new class_7654("textures/item", ".png.mcmeta");
	private static final class_7654 JSON_MODEL_LISTER = new class_7654("models", ".json");
	private static final class_7654 JSON_ITEM_TAG_LISTER = class_7654.method_45114("tags/item");
	
	@Override
	public Map<class_2960, String> getItemMcmeta() {
		return ITEM_TEXTURE_MCMETA;
	}
	
	@Override
	public void addItemMcmeta(class_2960 id, String mcmetaJson) {
		ITEM_TEXTURE_MCMETA.put(ITEM_PNG_MCMETA_LISTER.method_45112(id), mcmetaJson);
	}
	
	@Override
	public Map<class_2960, String> getItemTags() {
		return ITEM_TAGS;
	}
	
	@Override
	public void addItemTag(class_2960 id, String tagJson) {
		if (!ITEM_TAGS.containsKey(JSON_ITEM_TAG_LISTER.method_45112(id))) {
			ITEM_TAGS.put(JSON_ITEM_TAG_LISTER.method_45112(id), tagJson);
		} else {
			Gson gson = new Gson();
			JsonObject element = gson.fromJson(tagJson, JsonElement.class).getAsJsonObject();
			JsonArray newTags = element.get("values").getAsJsonArray();
			
			String oldTagJson = ITEM_TAGS.get(JSON_ITEM_TAG_LISTER.method_45112(id));
			JsonObject oldElement = gson.fromJson(oldTagJson, JsonElement.class).getAsJsonObject();
			JsonArray oldTags = oldElement.get("values").getAsJsonArray();
			
			newTags.addAll(oldTags);
			Collection<class_2960> ids = newTags.asList().stream()
					.map(JsonElement::getAsString)
					.map(class_2960::method_12829)
					.collect(Collectors.toCollection(ArrayList::new));
			ITEM_TAGS.put(JSON_ITEM_TAG_LISTER.method_45112(id), generatedTag(ids, false));
		}
	}
	
	@Override
	public Map<class_2960, String> getModels() {
		return MODELS;
	}
	
	@Override
	public void addModel(class_2960 id, String modelJson) {
		MODELS.put(JSON_MODEL_LISTER.method_45112(id), modelJson);
	}
	
	@Override
	public Map<class_2960, class_1011> getItemTextures() {
		return ITEM_TEXTURES;
	}
	
	@Override
	public void addItemTexture(class_2960 id, class_1011 image) {
		ITEM_TEXTURES.put(ITEM_PNG_LISTER.method_45112(id), image);
	}
	
	@Nullable
	@Override
	public class_7367<InputStream> getResource(class_2960 id) {
		class_7367<InputStream> supplier = method_14405(class_3264.field_14188, id);
		if (supplier == null) {
			return method_14405(class_3264.field_14190, id);
		} else {
			return supplier;
		}
	}
	
	public static String generatedTag(Collection<class_2960> ids, boolean replace) {
		Gson gson = new Gson();
		return String.format("""
			{
				"replace": %s,
				"values": %s
			}
			""", replace, gson.toJson(ids.stream().map(class_2960::toString).collect(Collectors.toList())));
	}
	
	private static class_3288.class_7680 fixedResources() {
		return new class_3288.class_7680() {
			@Override
			public @NotNull class_3262 method_52424(class_9224 location) {
				return INSTANCE;
			}
			
			@Override
			public @NotNull class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
				return INSTANCE;
			}
		};
	}
	
	@Override
	public ModMetadata getFabricModMetadata() {
		return Main.getModContainer().getMetadata();
	}
	
	@Override
	public ModResourcePack createOverlay(String overlay) {
		return new RuntimeResourcePackImpl();
	}
	
	@Nullable
	@Override
	public class_7367<InputStream> method_14410(String... elements) {
		class_4239.method_46345(elements);
		Optional<Path> optionalPath = Main.getModContainer().findPath("rrp/" + String.join("/", elements));
		return optionalPath.map(class_7367::create).orElse(null);
	}
	
	@Nullable
	@Override
	public class_7367<InputStream> method_14405(class_3264 packType, class_2960 id) {
		if (packType == class_3264.field_14188) {
			if (ITEM_TEXTURES.containsKey(id)) {
				return Conversions.convert(ITEM_TEXTURES.get(id));
			} else if (ITEM_TEXTURE_MCMETA.containsKey(id)) {
				return Conversions.convert(ITEM_TEXTURE_MCMETA.get(id));
			} if (MODELS.containsKey(id)) {
				return Conversions.convert(MODELS.get(id));
			}
		} else if (packType == class_3264.field_14190) {
			if (ITEM_TAGS.containsKey(id)) {
				return Conversions.convert(ITEM_TAGS.get(id));
			}
		}
		
		return null;
	}
	
	@Override
	public void method_14408(class_3264 packType, String namespace, String path, class_7664 resourceOutput) {
		if (Objects.equals(namespace, Constants.COMPAT_MOD_ID)) {
			if (packType == class_3264.field_14188) {
				if (path.equals("textures/item")) {
					for (var entry : ITEM_TEXTURES.entrySet()) {
						resourceOutput.accept(entry.getKey(), Conversions.convert(entry.getValue()));
					}
					for (var entry : ITEM_TEXTURE_MCMETA.entrySet()) {
						resourceOutput.accept(entry.getKey(), Conversions.convert(entry.getValue()));
					}
				} else if (path.equals("models")) {
					for (var entry : MODELS.entrySet()) {
						resourceOutput.accept(entry.getKey(), Conversions.convert(entry.getValue()));
					}
				}
			} else if (packType == class_3264.field_14190) {
				if (path.equals("tags/item")) {
					for (var entry : ITEM_TAGS.entrySet()) {
						resourceOutput.accept(entry.getKey(), Conversions.convert(entry.getValue()));
					}
				}
			}
		}
	}
	
	@Override
	public @NotNull Set<String> method_14406(class_3264 type) {
		if (type == class_3264.field_14188 || type == class_3264.field_14190) {
			return Set.of(Constants.COMPAT_MOD_ID);
		} else {
			return Set.of();
		}
	}
	
	@Nullable
	@Override
	public <T> T method_14407(class_3270<T> deserializer) throws IOException {
		return class_3255.method_14392(deserializer, Objects.requireNonNull(method_14410("pack.mcmeta")).get());
	}
	
	@Override
	public @NotNull class_9224 method_56926() {
		return LOCATION;
	}
	
	@Override
	public void close() {
	}
}
