/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.gui.creative_tab;

import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.item.Items;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.Initializable;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import java.util.function.Function;

import static gay.sylv.wij.impl.util.Constants.modId;

public class CreativeModeTabs implements Initializable {
	public static final CreativeModeTabs INSTANCE = new CreativeModeTabs();
	
	public static class_1761 WORLD_IN_A_JAR;
	public static class_1761 BARK;
	
	private CreativeModeTabs() {}
	
	@Override
	public void initialize() {
		WORLD_IN_A_JAR = register(
				Constants.COMPAT_MOD_ID,
				builder -> builder
						.method_47321(class_2561.method_43471("itemGroup." + Constants.MOD_ID))
						.method_47320(() -> Blocks.WORLD_JAR.item().method_7854())
						.method_47317((itemDisplayParameters, output) -> {
							output.method_45421(Blocks.WORLD_JAR.item());
							output.method_45421(Blocks.SUSSYSTONE.item());
							output.method_45421(Blocks.REINFORCED_ECHNOPLAST.item());
							output.method_45421(Blocks.CRACKED_BEDROCK.item());
							output.method_45421(Items.BEDROCK_SHARD);
							output.method_45421(Items.BEDROCK_PICKAXE);
							output.method_45421(Blocks.CORK_BLOCK.item());
						})
		);
		
		BARK = register(
				"bark",
				builder -> builder
						.method_47321(class_2561.method_43471("itemGroup." + Constants.MOD_ID + ".bark"))
						.method_47320(() -> Items.BARK.get(BarkType.OAK).method_7854())
						.method_47317(
								(itemDisplayParameters, output) ->
										Items.BARK.forEach((barkType, item) -> output.method_45421(item))
						)
		);
	}
	
	private static class_1761 register(String id, Function<class_1761.class_7913, class_1761.class_7913> builder) {
		return class_2378.method_10230(class_7923.field_44687, modId(id), builder.apply(FabricItemGroup.builder()).method_47324());
	}
}
