/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.item;

import gay.sylv.wij.impl.item.tag.ItemTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_40;
import net.minecraft.class_47;
import net.minecraft.class_5662;
import net.minecraft.class_8567;
import java.util.Optional;

public class BedrockPickaxeItem extends class_1810 {
	public BedrockPickaxeItem(class_1832 tier, class_1793 properties) {
		super(tier, properties);
	}
	
	public static void dropBedrockShard(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 miningEntity) {
		if (isBedrockMineable(level, state, miningEntity)) {
			class_3218 serverLevel = (class_3218) level;
			class_1657 player = (class_1657) miningEntity;
			class_8567 lootParams = new class_8567.class_8568(serverLevel)
					.method_51874(class_181.field_24424, class_243.method_24953(pos))
					.method_51874(class_181.field_1229, stack)
					.method_51874(class_181.field_1226, miningEntity)
					.method_51874(class_181.field_1224, state)
					.method_51871(player.method_7292())
					.method_51875(class_173.field_1172);
			class_47 lootContext = new class_47.class_48(lootParams).method_309(Optional.empty());
			int chance;
			if (stack.method_31573(ItemTags.DESTROYS_UNBREAKABLE)) {
				chance = class_5662.method_32462(0.0F, 2.0F).method_366(lootContext);
			} else if (stack.method_31573(ItemTags.CHIPS_UNBREAKABLE) ){
				chance = class_40.method_273(1, 1.0F / 4.0F).method_366(lootContext);
			} else {
				return;
			}
			if (!FabricLoader.getInstance().isModLoaded("breakingbedrock")) {
				level.method_8501(pos, gay.sylv.wij.impl.block.Blocks.CRACKED_BEDROCK.block().method_9564());
			} else {
				level.method_8501(pos, class_2246.field_10124.method_9564());
			}
			stack.method_7970(1, miningEntity, class_1304.field_6173);
			class_2248.method_9577(level, pos, new class_1799(Items.BEDROCK_SHARD, chance));
			level.method_8396(null, pos, class_3417.field_15236, class_3419.field_15245, 1.5F, 1.0F);
		}
	}
	
	public static boolean isBedrockMineable(class_1937 level, class_2680 state, class_1309 miningEntity) {
		return level instanceof class_3218 && state.method_27852(class_2246.field_9987) && miningEntity instanceof class_1657 player && !player.method_7337();
	}
}
