/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.item;

import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.impl.item.tool.tier.BedrockTier;
import gay.sylv.wij.impl.util.Initializable;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1810;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_7923;

import static gay.sylv.wij.impl.util.Constants.modId;

public final class Items implements Initializable {
	public static final Items INSTANCE = new Items();
	
	public static Map<BarkType, class_1792> BARK = new HashMap<>();
	public static class_1792 BEDROCK_PICKAXE;
	public static class_1792 BEDROCK_SHARD;
	
	private Items() {}
	
	@Override
	public void initialize() {
		BEDROCK_PICKAXE = register(
				"bedrock_pickaxe",
				new BedrockPickaxeItem(
						BedrockTier.INSTANCE,
						new class_1792.class_1793()
								.method_7894(class_1814.field_8907)
								.method_57348(class_1810.method_57346(BedrockTier.INSTANCE, 1.0F, -2.8F))
				)
		);
		
		BEDROCK_SHARD = register(
				"bedrock_shard",
				new class_1792(
						new class_1792.class_1793()
								.method_24359()
								.method_7894(class_1814.field_8907)
				)
		);
	}
	
	private static <I extends class_1792> I register(@NotNull String id, I item) {
		return class_2378.method_10230(class_7923.field_41178, modId(id), item);
	}
}
