/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.network;

import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static gay.sylv.wij.impl.util.Instantiation.packetType;

/**
 * Signals that a chunk outside the {@link WorldJarBlockEntity} has updated. This sends the {@link class_2841}&lt;{@link class_2680}&gt; of the external chunk.
 */
public record ExternalChunkUpdatePayload(class_2841<class_2680> blockStateContainer, class_243 centerOfJar) implements class_8710 {
	public static final class_9154<ExternalChunkUpdatePayload> TYPE = packetType("jar_external_chunk_update");
	public static final class_9139<class_9129, ExternalChunkUpdatePayload> CODEC = class_9139.method_56435(
			Networking.Codecs.BLOCK_STATE_PALETTED_CONTAINER, ExternalChunkUpdatePayload::blockStateContainer,
			Networking.Codecs.VEC3, ExternalChunkUpdatePayload::centerOfJar,
			ExternalChunkUpdatePayload::new
	);
	
	@Override
	public @NotNull class_9154<? extends class_8710> method_56479() {
		return TYPE;
	}
}
