/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.network;

import org.jetbrains.annotations.NotNull;

import static gay.sylv.wij.impl.util.Instantiation.packetType;

import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

/**
 * Sent to clients when the jar has loaded server-side.
 */
public record JarLoadedAckPayload(Networking.JarLocation jarLocation) implements class_8710 {
	public static final class_9154<JarLoadedAckPayload> TYPE = packetType("jar_loaded_ack");
	public static final class_9139<class_9129, JarLoadedAckPayload> CODEC = class_9139.method_56434(
			Networking.JarLocation.STREAM_CODEC, JarLoadedAckPayload::jarLocation,
			JarLoadedAckPayload::new
	);
	
	@Override
	public @NotNull class_9154<? extends class_8710> method_56479() {
		return TYPE;
	}
}
