/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.network;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gay.sylv.wij.impl.network.client.JarEnterPayload;
import gay.sylv.wij.impl.network.client.JarLoadedPayload;
import gay.sylv.wij.impl.util.Initializable;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static gay.sylv.wij.impl.util.Instantiation.blockStatePalettedContainer;

/**
 * Class for putting both-side networking-related things.
 */
public final class Networking implements Initializable {
	public static final Networking INSTANCE = new Networking();
	
	private Networking() {}
	
	public static class Codecs {
		public static final class_9139<class_9129, class_4076> SECTION_POS = new class_9139<>() {
			@Override
			public void encode(class_9129 buf, class_4076 sectionPos) {
				buf.method_52974(sectionPos.method_18694());
			}
			
			@Override
			public @NotNull class_4076 decode(class_9129 buf) {
				return class_4076.method_18677(buf.readLong());
			}
		};
		public static final class_9139<class_9129, class_2841<class_2680>> BLOCK_STATE_PALETTED_CONTAINER = new class_9139<>() {
			@Override
			public void encode(class_9129 buf, class_2841<class_2680> blockStateContainer) {
				blockStateContainer.method_12325(buf);
			}
			
			@Override
			public @NotNull class_2841<class_2680> decode(class_9129 buf) {
				class_2841<class_2680> blockStateContainer = blockStatePalettedContainer();
				blockStateContainer.method_12326(buf);
				return blockStateContainer;
			}
		};
		public static final class_9139<class_9129, class_2680> BLOCK_STATE = new class_9139<>() {
			@Override
			public void encode(class_9129 buf, class_2680 blockState) {
				buf.method_10804(class_2248.method_9507(blockState));
			}
			
			@Override
			public @NotNull class_2680 decode(class_9129 buf) {
				return class_2248.method_9531(buf.method_10816());
			}
		};
		public static final class_9139<class_9129, class_243> VEC3 = class_9139.method_56437(
				(buf, pos) -> {
					buf.method_52940(pos.method_10216());
					buf.method_52940(pos.method_10214());
					buf.method_52940(pos.method_10215());
				},
				buf -> new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble())
		);
		
		private Codecs() {}
	}
	
	public record JarLocation(class_2338 blockPos, class_5321<class_1937> dimension) {
		public static final class_9139<class_2540, JarLocation> STREAM_CODEC = new class_9139<>() {
			@Override
			public void encode(class_2540 buf, JarLocation jarLocation) {
				buf.method_10807(jarLocation.blockPos);
				buf.method_44116(jarLocation.dimension);
			}
			
			@Override
			public @NotNull JarLocation decode(class_2540 buf) {
				return new JarLocation(buf.method_10811(), buf.method_44112(class_7924.field_41223));
			}
		};
		
		public static final Codec<JarLocation> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				class_2338.field_25064.fieldOf("block_pos").forGetter(JarLocation::blockPos),
				class_5321.method_39154(class_7924.field_41223).fieldOf("dimension").forGetter(JarLocation::dimension)
		).apply(instance, JarLocation::new));
	}
	
	@Override
	public void initialize() {
		s2c(JarChunkUpdatePayload.TYPE, JarChunkUpdatePayload.CODEC);
		s2c(JarBlockUpdatePayload.TYPE, JarBlockUpdatePayload.CODEC);
		s2c(JarLoadedAckPayload.TYPE, JarLoadedAckPayload.CODEC);
		s2c(ExternalChunkUpdatePayload.TYPE, ExternalChunkUpdatePayload.CODEC);
		c2s(JarEnterPayload.TYPE, JarEnterPayload.CODEC);
		c2s(JarLoadedPayload.TYPE, JarLoadedPayload.CODEC);
		
		ServerPackets.INSTANCE.initialize();
	}
	
	private static <T extends class_8710> void s2c(class_8710.class_9154<T> type, class_9139<class_9129, T> codec) {
		PayloadTypeRegistry.playS2C().register(type, codec);
	}
	
	private static <T extends class_8710> void c2s(class_8710.class_9154<T> type, class_9139<class_9129, T> codec) {
		PayloadTypeRegistry.playC2S().register(type, codec);
	}
}
