/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.network;

import gay.sylv.wij.api.entity.event.ServerPlayerEventsExtra;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.duck.PlayerWithEnteredJar;
import gay.sylv.wij.impl.duck.PlayerWithReturn;
import gay.sylv.wij.impl.network.client.JarEnterPayload;
import gay.sylv.wij.impl.network.client.JarLoadedPayload;
import gay.sylv.wij.impl.util.Initializable;
import gay.sylv.wij.impl.util.Instantiation;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

/**
 * Registers receivers and handles non-dedicated server-side Client-to-Server-related packets.
 * @author sylv
 */
public final class ServerPackets implements Initializable {
	public static final ServerPackets INSTANCE = new ServerPackets();
	
	@Override
	public void initialize() {
		ServerPlayerEventsExtra.AFTER_SPAWN.register((connection, player, cookie) -> {
			if (player.method_37908().method_27983().equals(Dimensions.JAR)) {
				((PlayerWithEnteredJar) player).worldinajar$getJarLocation().ifPresent(jarLocation -> {
					class_3218 level = player.field_13995.method_3847(jarLocation.dimension());
					assert level != null;
					Optional<WorldJarBlockEntity> optionalJar = level.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type());
					if (optionalJar.isEmpty()) return;
					WorldJarBlockEntity jar = optionalJar.get();
					
					ServerPlayNetworking.send(player, createExternalChunkUpdate(level, jar));
				});
			}
		});
		ServerPlayNetworking.registerGlobalReceiver(JarEnterPayload.TYPE, (payload, context) -> {
			MinecraftServer server = context.server();
			class_3218 level = server.method_3847(payload.jarLocation().dimension());
			assert level != null;
			Optional<WorldJarBlockEntity> optionalJar = level.method_35230(payload.jarLocation().blockPos(), Blocks.WORLD_JAR.type());
			if (optionalJar.isEmpty()) return;
			WorldJarBlockEntity jar = optionalJar.get();
			
			if (jar.isLocked() && !context.player().method_7337()) {
				if (jar.method_10997() == null) return;
				
				jar.method_10997().method_8396(
						null,
						jar.method_11016(),
						class_3417.field_14731,
						class_3419.field_15248,
						1.0f,
						1.0f
				);
				context.player().method_7353(class_2561.method_43469("container.isLocked", "World Jar"), true);
				return;
			}
			
			class_3222 player = context.player();
			((PlayerWithReturn) player).worldinajar$setReturnLocation(
					new Networking.JarLocation(class_2338.method_49638(player.method_19538()), player.method_37908().method_27983())
			);
			((PlayerWithEnteredJar) player).worldinajar$setJarLocation(payload.jarLocation());
			((PlayerWithReturn) player).worldinajar$setReturnPos(player.method_19538());
			context.responseSender().sendPacket(createExternalChunkUpdate(level, jar));
			
			class_3218 targetLevel = Objects.requireNonNull(server.method_3847(Dimensions.JAR));
			class_5454 transition = new class_5454(targetLevel, class_243.method_24953(jar.getInternalSpawnPos()), class_243.field_1353, 0.0f, 0.0f, class_5454.field_52245);
			player.method_5731(transition);
		});
		ServerPlayNetworking.registerGlobalReceiver(JarLoadedPayload.TYPE, (payload, context) -> {
			Networking.JarLocation jarLocation = payload.jarLocation();
			
			context.server().execute(() -> {
				try {
					WorldJarBlockEntity jar = Objects.requireNonNull(context.server().method_3847(jarLocation.dimension()))
							.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type())
							.orElseThrow();
					jar.updateBlockStates(context.server());
					
					for (class_3222 player : PlayerLookup.tracking(jar)) {
						jar.sendJarChunks(player);
					}
				} catch (NullPointerException e) {
					throw new RuntimeException(e);
				} catch (NoSuchElementException ignored) {}
			});
		});
	}
	
	private ExternalChunkUpdatePayload createExternalChunkUpdate(class_3218 level, WorldJarBlockEntity jar) {
		class_2841<class_2680> externalBlockStateContainer = Instantiation.blockStatePalettedContainer();
		Iterator<class_2338> blockPosIterator = class_2338.method_10097(new class_2338(0, 0, 0), new class_2338(15, 15, 15)).iterator();
		for (class_2338 blockPos : class_2338.method_10097(jar.method_11016().method_10069(-8, -8, -8), jar.method_11016().method_10069(7, 7, 7))) {
			class_2338 pos = blockPosIterator.next();
			class_2680 blockState = level.method_8320(blockPos);
			externalBlockStateContainer.method_35321(pos.method_10263(), pos.method_10264(), pos.method_10260(), blockState);
		}
		return new ExternalChunkUpdatePayload(externalBlockStateContainer, jar.getCenterPos());
	}
}
