/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.util;

import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.impl.block.BlockHolder;
import gay.sylv.wij.impl.block.entity.type.BlockEntityHolder;
import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7367;

public final class Conversions {
	private Conversions() {}
	
	public static <I extends class_1792, BE extends class_2586> BlockEntityHolder<I, BE> convert(BlockHolder<I> holder, class_2591<BE> type) {
		return new BlockEntityHolder<>(holder.block(), holder.item(), type);
	}
	
	public static class_7367<InputStream> convert(class_1011 image) {
		return new class_7367<>() {
			@Override
			public @NotNull InputStream get() throws IOException {
				return new ByteArrayInputStream(image.method_24036());
			}
		};
	}
	
	public static class_7367<InputStream> convert(String string) {
		return convert(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
	}
	
	public static class_7367<InputStream> convert(InputStream inputStream) {
		return new class_7367<>() {
			@Override
			public @NotNull InputStream get() {
				return inputStream;
			}
		};
	}
	
	public static BarkType convert(Field field) throws IllegalAccessException {
		return (BarkType) field.get(null);
	}
	
	public static class_1923 convert(class_2338 pos) {
		return new class_1923(pos.method_10263() & 15, pos.method_10260() & 15);
	}
}
