/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.function.Consumer;

/**
 * A type of {@link ArrayList} that automatically clears dangling {@link SoftReference}s.
 * @param <E>
 */
public class WeakReferenceList<E> extends ArrayList<SoftReference<E>> {
	public void addAuto(E item) {
		super.add(new SoftReference<>(item));
	}
	
	public void forEachAuto(Consumer<? super E> action) {
		super.forEach(item -> {
			if (item.get() == null) {
				this.remove(item);
			}
			
			action.accept(item.get());
		});
	}
}
