/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.util.jar;

import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.util.CallerSensitive;
import gay.sylv.wij.impl.util.Constants;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;

import static gay.sylv.wij.impl.util.Assertions.checkCaller;
import static gay.sylv.wij.impl.util.Constants.modId;

/**
 * Does the calculations for figuring out where to place Jars in the Jar Dimension.
 */
public final class JarPlacer {
	private static final Logger LOGGER = LoggerFactory.getLogger(Constants.MOD_ID + "/JarPlacer");
	private static JarPlacer instance = null;
	
	private final MinecraftServer server;
	
	private JarPlacer(MinecraftServer server) {
		this.server = server;
	}
	
	private JarEntries getJarEntries() {
		return Objects.requireNonNull(server.method_3847(Dimensions.JAR), "Jar dimension must exist.")
				.method_17983()
				.method_17924(JarEntries.factory(), JarEntries.FILE_NAME);
	}
	
	@NotNull
	public static JarPlacer getInstance() {
		return Objects.requireNonNull(instance, "JarPlacer must be initialized.");
	}
	
	public static boolean isInitialized() {
		return instance != null;
	}
	
	@CallerSensitive
	public static void initialize(MinecraftServer server) throws IllegalAccessException {
		checkCaller(Main.class);
		instance = new JarPlacer(server);
	}
	
	@CallerSensitive
	public static void clear() throws IllegalAccessException {
		checkCaller(Main.class);
		instance = null;
	}
	
	public @NotNull JarEntry getFreeJarEntry() {
		return getJarEntries().getFreeJarEntry();
	}
	
	public boolean jarExists(JarEntry jarEntry, class_3218 level) {
		return !level.method_8320(jarEntry.chunkPos().method_8323()).method_26215();
	}
	
	public void placeJar(JarEntry jarEntry) {
		class_3218 level = Objects.requireNonNull(server.method_3847(Dimensions.JAR), "Jar dimension must exist.");
		if (!jarExists(jarEntry, level)) {
			class_3485 structureManager = level.method_14183();
			for (int x = 0; x < 2; x++) {
				for (int y = 0; y < 2; y++) {
					for (int z = 0; z < 2; z++) {
						class_3499 structureTemplate = structureManager.method_15094(modId("jar-" + x + "-" + y + "-" + z)).orElseThrow();
						if (!structureTemplate.method_15172(level, jarEntry.chunkPos().method_8323().method_10069(-1, -1, -1).method_10069(x * 48, y * 48, z * 48), class_2338.field_10980, new class_3492(), level.field_9229, 1 | 2)) {
							LOGGER.error("Failed to place jar in jar dimension!");
						}
					}
				}
			}
			level.method_8652(jarEntry.chunkPos().method_8323(), Blocks.WORLD_JAR.block().method_9564(), 1 | 2);
		}
	}
}
