/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.impl.worldgen;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5485;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;

public class JarChunkGenerator extends class_2794 {
	public static final MapCodec<JarChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(
			instance -> instance.group(
					class_1966.field_24713
							.fieldOf("biome_source")
							.forGetter(JarChunkGenerator::biomeSource)
			).apply(instance, JarChunkGenerator::new)
	);
	
	private final class_1966 field_12761;
	
	public JarChunkGenerator(class_1966 biomeSource) {
		super(biomeSource, JarChunkGenerator::jarGenSettings);
		this.field_12761 = biomeSource;
	}
	
	public class_1966 biomeSource() {
		return field_12761;
	}
	
	/**
	 * @return Jar generation settings.
	 */
	private static class_5485 jarGenSettings(class_6880<class_1959> biome) {
		return class_5485.field_26639;
	}
	
	@Override
	protected @NotNull MapCodec<? extends class_2794> method_28506() {
		return CODEC;
	}
	
	@Override
	public void method_12108(
			class_3233 level,
			long seed,
			class_7138 random,
			class_4543 biomeManager,
			class_5138 structureManager,
			class_2791 chunk,
			class_2893.class_2894 step
	) {
		/* no-op */
	}
	
	@Override
	public void method_12110(class_3233 level, class_5138 structureManager, class_7138 random, class_2791 chunk) {
		/* no-op */
	}
	
	@Override
	public void method_12107(class_3233 level) {
		/* no-op */
	}
	
	@Override
	public int method_12104() {
		return 320;
	}
	
	@Override
	public @NotNull CompletableFuture<class_2791> method_12088(
			class_6748 blender,
			class_7138 randomState,
			class_5138 structureManager,
			class_2791 chunk
	) {
		return CompletableFuture.completedFuture(chunk);
	}
	
	@Override
	public int method_16398() {
		return 0;
	}
	
	@Override
	public int method_33730() {
		return -64;
	}
	
	@Override
	public int method_16397(int x, int z, class_2902.class_2903 type, class_5539 level, class_7138 random) {
		return 320;
	}
	
	@Override
	public @NotNull class_4966 method_26261(int x, int z, class_5539 height, class_7138 random) {
		return new class_4966(0, new class_2680[]{});
	}
	
	@Override
	public void method_40450(List<String> info, class_7138 random, class_2338 pos) {
		/* no-op */
	}
}
