/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.impl.item.Items;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_4861;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.world.inventory.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Locale;

@Mixin(class_1706.class)
public abstract class AnvilMenuMixin extends class_4861 {
	@Shadow
	@Final
	private class_3915 cost;
	@Unique
	private static final class_4174 WELL_DONE = new class_4174.class_4175()
			.method_19240()
			.method_19238(2)
			.method_19237(0.5f)
			.method_19239(new class_1293(class_1294.field_5921, 1, 0), 1.0f)
			.method_19242();
	@Unique
	private static final class_9290 WELL_DONE_LORE = new class_9290(List.of(class_2561.method_43471("worldinajar.lore.bark.well_done")));
	@Unique
	private static final class_2561 WELL_DONE_NAME = class_2561.method_43471("item.worldinajar.bark.minecraft.spruce.well_done");
	@Unique
	private boolean wellDone = false;
	
	public AnvilMenuMixin(@Nullable class_3917<?> type, int containerId, class_1661 playerInventory, class_3914 access) {
		super(type, containerId, playerInventory, access);
	}
	
	@SuppressWarnings("MixinExtrasOperationParameters")
	@WrapOperation(
			method = "createResult",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;",
					ordinal = 0
			)
	)
	private <T> @Nullable T wellDone(class_1799 instance, class_9331<? super T> component, @Nullable T value, Operation<T> original) {
		wellDone = value instanceof class_2561 text && instance.method_31574(Items.BARK.get(BarkType.SPRUCE)) && text.getString().toLowerCase(Locale.ROOT).equals("well done");
		if (wellDone) {
			instance.method_57379(class_9334.field_49637, new class_9280(1));
			instance.method_57379(class_9334.field_50239, WELL_DONE_NAME);
			instance.method_57379(class_9334.field_49632, WELL_DONE_LORE);
			instance.method_57379(class_9334.field_50075, WELL_DONE);
		}
		return original.call(instance, component, value);
	}
	
	@SuppressWarnings("UnresolvedLocalCapture")
	@Inject(
			method = "createResult",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/inventory/ResultContainer;setItem(ILnet/minecraft/world/item/ItemStack;)V",
					shift = At.Shift.BEFORE
			)
	)
	private void beforeSetItem(CallbackInfo ci, @Local(ordinal = 1) class_1799 itemStack2) {
		if (wellDone) {
			itemStack2.method_57381(class_9334.field_49631);
			cost.method_17404(1);
		}
	}
}
