/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.impl.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5662;
import net.minecraft.class_7923;
import net.minecraft.class_8567;

@Mixin(class_1743.class)
public final class AxeItemMixin {
	@WrapOperation(
			method = "useOn",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/item/AxeItem;evaluateNewBlockState(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/block/state/BlockState;)Ljava/util/Optional;"
			)
	)
	private Optional<class_2680> onStrip(class_1743 instance, class_1937 level, class_2338 pos, @Nullable class_1657 player, class_2680 state, Operation<Optional<class_2680>> original) {
		Optional<class_2680> newState = original.call(instance, level, pos, player, state);
		
		if (newState.isPresent() && level instanceof class_3218 serverLevel && player != null) {
			BarkType.getTypes().stream()
					.filter(type -> state.method_27852(class_7923.field_41175.method_10223(type.getLogBlockId())) || state.method_27852(class_7923.field_41175.method_10223(type.getWoodBlockId())))
					.forEach(type -> {
						class_8567 lootParams = new class_8567.class_8568(serverLevel)
								.method_51874(class_181.field_24424, class_243.method_24953(pos))
								.method_51874(class_181.field_1229, player.method_6047())
								.method_51874(class_181.field_1226, player)
								.method_51874(class_181.field_1224, state)
								.method_51871(player.method_7292())
								.method_51875(class_173.field_1172);
						class_47 lootContext = new class_47.class_48(lootParams).method_309(Optional.empty());
						class_2248.method_9577(level, player.method_24515(), new class_1799(Objects.requireNonNull(Items.BARK.get(type)), class_5662.method_32462(1.0F, 4.0F).method_366(lootContext)));
					});
		}
		
		return newState;
	}
}
