/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.item.tag.ItemTags;
import gay.sylv.wij.impl.util.Constants;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_4970.class)
public abstract class BlockBehaviourMixin {
	private BlockBehaviourMixin() {}
	
	@WrapOperation(
			method = "getDestroyProgress",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/world/level/block/state/BlockState;getDestroySpeed(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"
			)
	)
	private float bypassUnbreakability(class_2680 state, class_1922 level, class_2338 pos, Operation<Float> original, @Local(argsOnly = true) class_1657 player) {
		if (state.method_26164(BlockTags.UNBREAKABLE) && player.method_6047().method_31573(ItemTags.CHIPS_OR_DESTROYS_UNBREAKABLE) && pos.method_10264() > level.method_31607()) {
			return Constants.UNBREAKABLE_DESTROY_SPEED;
		} else {
			return original.call(state, level, pos);
		}
	}
}
