/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import gay.sylv.wij.impl.datagen.RuntimeResourcePackImpl;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_7678;

@Mixin(value = class_7678.class, priority = 999)
public abstract class BuiltInPackSourceMixin {
	@Inject(
			method = "listBundledPacks",
			at = @At("RETURN")
	)
	private void addBuiltinResourcePacks(Consumer<class_3288> packConsumer, CallbackInfo ci) {
		packConsumer.accept(createBuiltinPack(class_3264.field_14188));
		packConsumer.accept(createBuiltinPack(class_3264.field_14190));
	}
	
	@Unique
	@Nullable
	private class_3288 createBuiltinPack(class_3264 type) {
		return class_3288.method_45275(RuntimeResourcePackImpl.INSTANCE.method_56926(), RuntimeResourcePackImpl.FIXED_RESOURCES, type, RuntimeResourcePackImpl.BUILT_IN_SELECTION_CONFIG);
	}
}
