/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.duck.PlayerWithEnteredJar;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Mixin(class_1297.class)
abstract class EntityMixin {
	@Shadow
	public abstract class_1937 level();
	
	@Inject(
			method = "setLevel",
			at = @At("TAIL")
	)
	private void afterSetLevel(class_1937 level, CallbackInfo ci) {
		//noinspection ConstantValue
		if (!level.method_8608() && level.method_27983().equals(Dimensions.JAR) && (class_1297) (Object) this instanceof class_3222 player && !(player instanceof FakePlayer)) {
			Main.createFakePlayer((class_3218) level, player);
		}
	}
	
	@Inject(
			method = "setPos(DDD)V",
			at = @At("TAIL")
	)
	private void afterSetPos(double oldX, double oldY, double oldZ, CallbackInfo ci) {
		if ((class_1297) (Object) this instanceof class_3222 player && player.method_37908().method_27983().equals(Dimensions.JAR)) {
			((PlayerWithEnteredJar) this).worldinajar$getJarLocation().ifPresent(jarLocation -> {
				class_3218 jarLevel = Objects.requireNonNull(player.field_13995.method_3847(jarLocation.dimension())).method_8410();
				Optional<WorldJarBlockEntity> optionalJar = jarLevel.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type());
				if (optionalJar.isEmpty()) return;
				WorldJarBlockEntity jar = optionalJar.get();
				class_2338 topCorner = jar.getInternalPos();
				double x = oldX - topCorner.method_10263();
				double y = oldY - topCorner.method_10264();
				double z = oldZ - topCorner.method_10260();
				x /= jar.getScale();
				y /= jar.getScale();
				z /= jar.getScale();
				x += jar.method_11016().method_10263();
				y += jar.method_11016().method_10264();
				z += jar.method_11016().method_10260();
				Optional<FakePlayer> optionalFakePlayer = Main.getFakePlayer(jar, player);
				if (optionalFakePlayer.isEmpty()) return;
				FakePlayer fakePlayer = optionalFakePlayer.get();
				fakePlayer.method_5814(x, y, z);
			});
		}
	}
	
	@Inject(
			method = "setRot",
			at = @At("TAIL")
	)
	private void afterSetRot(float yRot, float xRot, CallbackInfo ci) {
		worldinajar$setRot(fakePlayer -> {
			fakePlayer.method_36456(yRot);
			fakePlayer.method_36457(xRot);
		});
	}
	
	@Inject(
			method = "setXRot",
			at = @At("TAIL")
	)
	private void afterSetXRot(float xRot, CallbackInfo ci) {
		worldinajar$setRot(fakePlayer -> fakePlayer.method_36457(xRot));
	}
	
	@Inject(
			method = "setYRot",
			at = @At("TAIL")
	)
	private void afterSetYRot(float yRot, CallbackInfo ci) {
		worldinajar$setRot(fakePlayer -> fakePlayer.method_36456(yRot));
	}
	
	@Unique
	private void worldinajar$setRot(Consumer<FakePlayer> setRot) {
		if ((class_1297) (Object) this instanceof class_3222 player && player.method_37908().method_27983().equals(Dimensions.JAR)) {
			((PlayerWithEnteredJar) this).worldinajar$getJarLocation().ifPresent(jarLocation -> {
				class_3218 jarLevel = Objects.requireNonNull(player.field_13995.method_3847(jarLocation.dimension())).method_8410();
				Optional<WorldJarBlockEntity> optionalJar = jarLevel.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type());
				if (optionalJar.isEmpty()) return;
				WorldJarBlockEntity jar = optionalJar.get();
				Optional<FakePlayer> optionalFakePlayer = Main.getFakePlayer(jar, player);
				if (optionalFakePlayer.isEmpty()) return;
				FakePlayer fakePlayer = optionalFakePlayer.get();
				setRot.accept(fakePlayer);
			});
		}
	}
}
