/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.dimension.Dimensions;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_6749;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;

@Mixin(class_2818.class)
public abstract class LevelChunkMixin extends class_2791 {
	@Shadow
	@Final
	class_1937 level;
	
	public LevelChunkMixin(
			class_1923 chunkPos, class_2843 upgradeData,
			class_5539 levelHeightAccessor, class_2378<class_1959> biomeRegistry,
			long inhabitedTime, @Nullable class_2826[] sections,
			@Nullable class_6749 blendingData
	) {
		super(chunkPos, upgradeData, levelHeightAccessor, biomeRegistry, inhabitedTime, sections, blendingData);
	}

	@Inject(
			method = "setBlockState",
			at = @At("RETURN")
	)
	private void updateWorldJar(class_2338 pos, class_2680 state, boolean isMoving, CallbackInfoReturnable<class_2680> cir) {
		if (!Main.DISABLE_LAG && !this.level.method_8608() && this.level.method_27983().equals(Dimensions.JAR)) {
			// TODO: optimize/cache this somehow
			WorldJarBlockEntity.INSTANCES.forEachAuto(jar -> {
				if (jar.hasBlockPos(pos)) {
					class_4076 sectionPos = class_4076.method_18682(pos.method_10059(jar.getInternalPos()));
					jar.updateSectionStates(Objects.requireNonNull(this.level.method_8503()), sectionPos);
					for (class_3222 player : PlayerLookup.tracking(jar)) {
						jar.sendJarChunk(player, sectionPos);
					}
				}
			});
		}
	}
}
