/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.dimension.Dimensions;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public class MultiPlayerGameModeMixin {
	@Shadow
	@Final
	private class_310 minecraft;
	
	@Inject(
			method = "destroyBlock",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/Item;canAttackBlock(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z"),
			cancellable = true
	)
	private void dontDestroyWorldJar(class_2338 pos, CallbackInfoReturnable<Boolean> cir, @Local class_2680 state) {
		if (this.minecraft.field_1687 != null && this.minecraft.field_1687.method_27983().equals(Dimensions.JAR) && state.method_27852(Blocks.WORLD_JAR.block())) {
			cir.setReturnValue(false);
			cir.cancel();
		}
	}
}
