/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import gay.sylv.wij.api.entity.event.ServerPlayerEventsExtra;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
abstract class PlayerListMixin {
	@Inject(
			method = "placeNewPlayer",
			at = @At("TAIL")
	)
	private void afterSpawn(class_2535 connection, class_3222 player, class_8792 cookie, CallbackInfo ci) {
		ServerPlayerEventsExtra.AFTER_SPAWN.invoker().afterSpawn(connection, player, cookie);
	}
	
	@WrapOperation(
			method = "getPlayerByName",
			at = @At(value = "INVOKE", target = "Lcom/mojang/authlib/GameProfile;getName()Ljava/lang/String;")
	)
	private String ignoreFakePlayer(GameProfile instance, Operation<String> original) {
		if (instance.getId().version() != 3) {
			return original.call(instance);
		} else {
			return ""; // an impossible name, so it's never equal
		}
	}
}
