/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin;

import gay.sylv.wij.impl.attachment.Attachments;
import gay.sylv.wij.impl.duck.PlayerWithEnteredJar;
import gay.sylv.wij.impl.duck.PlayerWithReturn;
import gay.sylv.wij.impl.network.Networking;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5321;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 implements PlayerWithReturn, PlayerWithEnteredJar {
	protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
		super(entityType, level);
	}
	
	@Override
	public @NotNull class_5321<class_1937> worldinajar$getReturnDimension() {
		if (hasAttached(Attachments.RETURN_JAR_LOCATION)) {
			return getAttachedOrThrow(Attachments.RETURN_JAR_LOCATION).dimension();
		} else {
			return class_1937.field_25179;
		}
	}
	
	@Override
	public @NotNull class_243 worldinajar$getReturnPos() {
		if (hasAttached(Attachments.PLAYER_RETURN_POS)) {
			return getAttachedOrThrow(Attachments.PLAYER_RETURN_POS);
		} else if (!method_37908().method_8608()) {
			return Objects.requireNonNull(method_37908().method_8503()).method_30002().method_43126().method_46558();
		} else {
			return new class_243(0.0d, 0.0d, 0.0d);
		}
	}
	
	@Override
	public void worldinajar$setReturnPos(@NotNull class_243 pos) {
		setAttached(Attachments.PLAYER_RETURN_POS, pos);
	}
	
	@Override
	public void worldinajar$setReturnLocation(Networking.@NotNull JarLocation returnLocation) {
		setAttached(Attachments.RETURN_JAR_LOCATION, returnLocation);
	}
	
	@Override
	public void worldinajar$RemoveReturnLocation() {
		removeAttached(Attachments.RETURN_JAR_LOCATION);
	}
	
	@Override
	public Optional<Networking.JarLocation> worldinajar$getJarLocation() {
		return Optional.ofNullable(getAttached(Attachments.RETURN_JAR_LOCATION));
	}
	
	@Override
	public void worldinajar$setJarLocation(Networking.JarLocation location) {
		setAttached(Attachments.RETURN_JAR_LOCATION, location);
	}
}
