/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin.breakingbedrock;

import net.anawesomguy.breakingbedrock.BedrockBlock;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(BedrockBlock.class)
@Pseudo
public abstract class Mixin_BedrockBlock extends class_4970 {
	public Mixin_BedrockBlock(class_2251 properties) {
		super(properties);
	}
	
	@Inject(
			method = "getDestroyProgress",
			at = @At("HEAD"),
			cancellable = true
	)
	private void overrideDestroyProgress(class_2680 state, class_1657 player, class_1922 level, class_2338 pos, CallbackInfoReturnable<Float> cir) {
		cir.setReturnValue(super.method_9594(state, player, level, pos));
	}
}
