/**
 * World In a Jar
 * Copyright (C) 2024  VulpixelMC
 * <p>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package gay.sylv.wij.mixin.client;

import com.mojang.authlib.GameProfile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.Objects;
import net.minecraft.class_1071;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

@Mixin(class_1071.class)
abstract class SkinManagerMixin {
	@ModifyVariable(
			method = "getOrLoad",
			at = @At("HEAD"),
			argsOnly = true,
			index = 1
	)
	private GameProfile getOrLoadTinySkin(GameProfile value) {
		if (value.getId().version() == 3) {
			class_310 client = class_310.method_1551();
			if (client.method_1558() == null && !client.method_1542()) return value;
			String playerName = value.getName();
			if (client.method_1542()) {
				class_1657 player = Objects.requireNonNull(client.method_1576()).method_3760().method_14566(playerName);
				if (player == null) return value;
				
				return player.method_7334();
			}
			
			class_634 connection = client.method_1562();
			if (connection == null) return value;
			
			class_640 playerInfo = connection.method_2874(playerName);
			if (playerInfo == null) return value;
			return playerInfo.method_2966();
		}
		
		return value;
	}
}
