/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.api.block;

import gay.sylv.wij.api.datagen.GroupedIdentifier;
import gay.sylv.wij.impl.datagen.DynamicDataGenerator;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.MapWithException;
import gay.sylv.wij.impl.util.SafeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_7654;

public record BarkType(class_2960 logTextureId, String woodName, String fullWoodName, int frames) implements GroupedIdentifier
{
    public static final BarkType ACACIA = new BarkType(Constants.vanilla("acacia_log"));
    public static final BarkType BIRCH = new BarkType(Constants.vanilla("birch_log"));
    public static final BarkType CHERRY = new BarkType(Constants.vanilla("cherry_log"));
    public static final BarkType DARK_OAK = new BarkType(Constants.vanilla("dark_oak_log"));
    public static final BarkType JUNGLE = new BarkType(Constants.vanilla("jungle_log"));
    public static final BarkType MANGROVE = new BarkType(Constants.vanilla("mangrove_log"));
    public static final BarkType OAK = new BarkType(Constants.vanilla("oak_log"));
    public static final BarkType SPRUCE = new BarkType(Constants.vanilla("spruce_log"));
    public static final BarkType WARPED = new BarkType(Constants.vanilla("warped_stem"), "hyphae", 5);
    public static final BarkType CRIMSON = new BarkType(Constants.vanilla("crimson_stem"), "hyphae", 5);
    private static final List<BarkType> TYPES = new ArrayList<BarkType>();
    private static final class_7654 PNG_LISTER = new class_7654("textures/block", ".png");

    private BarkType(class_2960 id) {
        this(id, "wood");
    }

    private BarkType(class_2960 id, String fullWoodName, int frames) {
        this(id, BarkType.defaultWoodName(id), fullWoodName, frames);
    }

    private BarkType(class_2960 id, String fullWoodName) {
        this(id, fullWoodName, 1);
    }

    public boolean isAnimated() {
        return this.frames > 1;
    }

    public class_2960 toFilePath() {
        return PNG_LISTER.method_45112(this.logTextureId);
    }

    public class_2960 getLogBlockId() {
        return this.logTextureId;
    }

    public class_2960 getWoodBlockId() {
        return this.logTextureId.method_45136(this.woodName + "_" + this.fullWoodName);
    }

    @Override
    public String getGroup() {
        return "bark";
    }

    @Override
    public String getNamespace() {
        return this.logTextureId.method_12836();
    }

    @Override
    public String getPath() {
        return this.woodName();
    }

    public static void registerAll(Class<?> utilityClass) {
        Arrays.stream(utilityClass.getDeclaredFields()).filter(field -> SafeMap.isStaticAccessible(field, BarkType.class)).map(MapWithException::convert).peek(BarkType::register).peek(DynamicDataGenerator.ItemGenerator::generateModel).peek(DynamicDataGenerator.ItemGenerator::generateBarkTag).forEach(DynamicDataGenerator.ItemGenerator::registerBark);
    }

    public static void register(BarkType type) {
        if (type != null) {
            TYPES.add(type);
        }
    }

    public static Collection<BarkType> getTypes() {
        return TYPES;
    }

    private static String defaultWoodName(class_2960 id) {
        String path = id.method_12832();
        int logIndex = path.lastIndexOf("_log");
        int stemIndex = path.lastIndexOf("_stem");
        return path.substring(0, logIndex != -1 ? logIndex : stemIndex).replace("block/", "");
    }
}

