/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl;

import gay.sylv.wij.api.entity.event.ServerPlayerEventsExtra;
import gay.sylv.wij.impl.attachment.Attachments;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.component.Components;
import gay.sylv.wij.impl.datagen.DynamicDataGenerator;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.duck.PlayerWithEnteredJar;
import gay.sylv.wij.impl.gui.creative_tab.CreativeModeTabs;
import gay.sylv.wij.impl.item.BedrockPickaxeItem;
import gay.sylv.wij.impl.item.Items;
import gay.sylv.wij.impl.item.tag.ItemTags;
import gay.sylv.wij.impl.network.Networking;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.jar.JarPlacer;
import gay.sylv.wij.impl.worldgen.JarChunkGenerator;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
implements ModInitializer {
    public static final Logger LOGGER = Main.getLogger(Main.class);
    public static final boolean DISABLE_LAG = true;
    private static EnvType environment;

    public void onInitialize() {
        LOGGER.info("Initializing {}", (Object)"World In a Jar");
        environment = FabricLoader.getInstance().getEnvironmentType();
        Components.INSTANCE.initialize();
        Attachments.INSTANCE.initialize();
        Blocks.INSTANCE.initialize();
        Items.INSTANCE.initialize();
        DynamicDataGenerator.INSTANCE.initialize();
        CreativeModeTabs.INSTANCE.initialize();
        Networking.INSTANCE.initialize();
        class_2378.method_10230((class_2378)class_7923.field_41157, (class_2960)Constants.modId("jar"), JarChunkGenerator.CODEC);
        ServerLifecycleEvents.SERVER_STARTED.register(Main::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPED.register(Main::onServerStop);
        ServerPlayerEventsExtra.AFTER_SPAWN.register((connection, player, cookie) -> {
            if (!(player instanceof FakePlayer) && player.method_37908().method_27983().equals(Dimensions.JAR)) {
                Main.createFakePlayer((class_3218)player.method_37908(), player);
            }
            if (!(player instanceof FakePlayer) && !player.method_37908().method_27983().equals(Dimensions.JAR)) {
                Objects.requireNonNull(player.method_5996(class_5134.field_47760)).method_6200(Constants.modId("tiny"));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (!(handler.method_32311() instanceof FakePlayer) && handler.method_32311().method_37908().method_27983().equals(Dimensions.JAR)) {
                Main.removeFakePlayer(handler.method_32311().method_51469(), handler.method_32311());
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> server.method_3760().method_14571().forEach(player -> {
            if (!(player instanceof FakePlayer) && player.method_37908().method_27983().equals(Dimensions.JAR)) {
                Main.removeFakePlayer(player.method_51469(), player);
            }
        }));
        PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, blockEntity) -> {
            if (player.method_6047().method_31573(ItemTags.CHIPS_OR_DESTROYS_UNBREAKABLE) && BedrockPickaxeItem.isBedrockMineable(level, state, (class_1309)player)) {
                BedrockPickaxeItem.dropBedrockShard(player.method_6047(), level, state, pos, (class_1309)player);
            }
            return !state.method_26164(BlockTags.UNBREAKABLE) || player.method_31549().field_7477;
        });
        LOGGER.info("Finished loading {}", (Object)"World In a Jar");
    }

    public static void createFakePlayer(class_3218 jarLevel, class_3222 player) {
        ((PlayerWithEnteredJar)player).worldinajar$getJarLocation().ifPresent(jarLocation -> {
            class_3218 outsideJarLevel = Objects.requireNonNull(Objects.requireNonNull(jarLevel.method_8503()).method_3847(jarLocation.dimension()));
            Optional optionalJar = outsideJarLevel.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type());
            if (optionalJar.isEmpty()) {
                return;
            }
            WorldJarBlockEntity jar = (WorldJarBlockEntity)optionalJar.get();
            FakePlayer fakePlayer = jar.getOrCreateFakePlayer(outsideJarLevel, player);
            class_1324 attribute = Objects.requireNonNull(fakePlayer.method_5996(class_5134.field_47760));
            attribute.method_6200(Constants.modId("tiny"));
            class_1322 modifier = new class_1322(Constants.modId("tiny"), (double)jar.getVisualScale() - 1.0, class_1322.class_1323.field_6328);
            attribute.method_26835(modifier);
            fakePlayer.method_51468(outsideJarLevel);
            class_3324 playerList = jarLevel.method_8503().method_3760();
            playerList.method_14581((class_2596)class_2703.method_43886(List.of(fakePlayer)));
            outsideJarLevel.method_18213((class_3222)fakePlayer);
        });
    }

    public static void removeFakePlayerWithJar(WorldJarBlockEntity jar, class_3218 outsideJarLevel, class_3222 player) {
        Optional<FakePlayer> optionalFakePlayer = Main.getFakePlayer(jar, player);
        if (optionalFakePlayer.isEmpty()) {
            return;
        }
        FakePlayer fakePlayer = optionalFakePlayer.get();
        Main.removeKnownFakePlayerWithJar(jar, outsideJarLevel, fakePlayer);
    }

    public static void removeKnownFakePlayerWithJar(WorldJarBlockEntity jar, class_3218 outsideJarLevel, FakePlayer fakePlayer) {
        class_3324 playerList = outsideJarLevel.method_8503().method_3760();
        jar.getFakePlayers().remove((Object)fakePlayer.method_5667());
        playerList.method_14611((class_3222)fakePlayer);
    }

    public static void removeFakePlayer(class_3218 jarLevel, class_3222 player) {
        jarLevel.method_8503().execute(() -> ((PlayerWithEnteredJar)player).worldinajar$getJarLocation().ifPresent(jarLocation -> {
            class_3218 outsideJarLevel = Objects.requireNonNull(Objects.requireNonNull(jarLevel.method_8503()).method_3847(jarLocation.dimension()));
            Optional optionalJar = outsideJarLevel.method_35230(jarLocation.blockPos(), Blocks.WORLD_JAR.type());
            if (optionalJar.isEmpty()) {
                return;
            }
            WorldJarBlockEntity jar = (WorldJarBlockEntity)optionalJar.get();
            Main.removeFakePlayerWithJar(jar, outsideJarLevel, player);
        }));
    }

    public static Optional<FakePlayer> getFakePlayer(WorldJarBlockEntity jar, class_3222 player) {
        UUID uuid = UUID.nameUUIDFromBytes(player.method_5477().getString().getBytes(StandardCharsets.UTF_8));
        return Optional.ofNullable((FakePlayer)jar.getFakePlayers().get((Object)uuid));
    }

    public static Optional<EnvType> getEnvironment() {
        return Optional.ofNullable(environment);
    }

    public static boolean isEnvType(EnvType type) {
        return Main.getEnvironment().orElseThrow() == type;
    }

    public static boolean isClient() {
        return Main.isEnvType(EnvType.CLIENT);
    }

    public static ModContainer getModContainer() {
        return (ModContainer)FabricLoader.getInstance().getModContainer("worldinajar").orElseThrow();
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger((String)("World In a Jar/" + clazz.getName()));
    }

    private static void onServerStart(MinecraftServer server) {
        try {
            JarPlacer.initialize(server);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void onServerStop(MinecraftServer server) {
        try {
            JarPlacer.clear();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

