/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl.block.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import gay.sylv.wij.api.block.WorldJar;
import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.client.render.JarChunk;
import gay.sylv.wij.impl.client.render.JarLevelChunkSection;
import gay.sylv.wij.impl.client.render.JarLevelLightEngine;
import gay.sylv.wij.impl.client.render.JarRenderChunkRegion;
import gay.sylv.wij.impl.component.Components;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.duck.PlayerWithReturn;
import gay.sylv.wij.impl.network.JarChunkUpdatePayload;
import gay.sylv.wij.impl.network.JarLoadedAckPayload;
import gay.sylv.wij.impl.network.Networking;
import gay.sylv.wij.impl.network.client.JarEnterPayload;
import gay.sylv.wij.impl.network.client.JarLoadedPayload;
import gay.sylv.wij.impl.util.WeakReferenceList;
import gay.sylv.wij.impl.util.jar.JarEntry;
import gay.sylv.wij.mixin.Accessor_BaseContainerBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2823;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8527;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9062;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldJarBlockEntity
extends class_2624
implements class_2823,
WorldJar {
    private int scale = 64;
    private class_2338 internalSpawnPos = DEFAULT_SPAWN_POS;
    private static final int DEFAULT_SCALE = 64;
    private static final class_2338 DEFAULT_SPAWN_POS = new class_2338(0, -64, 0);
    public static final WeakReferenceList<WorldJarBlockEntity> INSTANCES = new WeakReferenceList();
    public static final class_1273 CONTAINER_LOCK = new class_1273("glowcase");
    private final Long2ObjectMap<JarLevelChunkSection> chunkSections = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<JarChunk> chunks = new Long2ObjectOpenHashMap();
    @Environment(value=EnvType.CLIENT)
    public JarRenderChunkRegion renderChunkRegion;
    @Nullable
    private Networking.JarLocation targetJarLocation;
    private JarEntry jarEntry = new JarEntry(-1);
    public boolean statesChanged = false;
    private final Object2ObjectMap<UUID, FakePlayer> fakePlayers = new Object2ObjectOpenHashMap();
    private boolean loadedNotPlaced = false;

    public WorldJarBlockEntity(class_2338 pos, class_2680 blockState) {
        super(Blocks.WORLD_JAR.type(), pos, blockState);
        INSTANCES.addAuto(this);
    }

    public float getVisualScale() {
        return 1.0f / (float)this.scale;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isLocked() {
        return ((Accessor_BaseContainerBlockEntity)((Object)this)).getLockKey() != class_1273.field_5817;
    }

    public void setLocked(boolean locked) {
        ((Accessor_BaseContainerBlockEntity)((Object)this)).setLockKey(locked ? CONTAINER_LOCK : class_1273.field_5817);
    }

    public void setBlockState(class_2338 pos, class_2680 state) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        JarLevelChunkSection section = (JarLevelChunkSection)this.chunkSections.get(sectionPos.method_18694());
        if (section == null) {
            return;
        }
        section.setBlockState(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, state);
    }

    public class_2680 getBlockState(class_2338 pos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        JarLevelChunkSection section = (JarLevelChunkSection)this.chunkSections.get(sectionPos.method_18694());
        if (section == null) {
            return class_2246.field_10124.method_9564();
        }
        return section.getBlockState(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
    }

    public class_3610 getFluidState(class_2338 pos) {
        return this.getBlockState(pos).method_26227();
    }

    public void updateBlockStates(MinecraftServer server) {
        class_3218 level = server.method_3847(Dimensions.JAR);
        int max = this.scale;
        for (int x = 0; x < max; ++x) {
            for (int y = 0; y < max; ++y) {
                for (int z = 0; z < max; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    assert (level != null);
                    class_2680 state = level.method_8320(pos.method_10081((class_2382)this.getInternalPos()));
                    this.setBlockState(pos, state);
                }
            }
        }
    }

    public void updateSectionStates(MinecraftServer server, class_4076 sectionPos) {
        class_3218 level = server.method_3847(Dimensions.JAR);
        int min = sectionPos.method_19527();
        int max = sectionPos.method_19530();
        for (int x = min; x < max; ++x) {
            for (int y = min; y < max; ++y) {
                for (int z = min; z < max; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    assert (level != null);
                    class_2680 state = level.method_8320(pos.method_10081((class_2382)this.getInternalPos()));
                    this.setBlockState(pos, state);
                }
            }
        }
    }

    private void initializeServerChunks() {
        this.chunkSections.clear();
        this.chunks.clear();
        int max = this.getChunkDiameter() - 1;
        for (int x = 0; x < max; ++x) {
            for (int y = 0; y < max; ++y) {
                for (int z = 0; z < max; ++z) {
                    class_4076 sectionPos = class_4076.method_18676((int)x, (int)y, (int)z);
                    JarLevelChunkSection chunkSection = new JarLevelChunkSection(sectionPos, false);
                    class_1923 chunkPos = new class_1923(sectionPos.method_10263(), sectionPos.method_10260());
                    JarChunk chunk = new JarChunk(chunkPos, this);
                    this.chunkSections.put(sectionPos.method_18694(), (Object)chunkSection);
                    this.chunks.put(chunkPos.method_8324(), (Object)chunk);
                }
            }
        }
    }

    public void sendJarChunks(class_3222 player) {
        Networking.JarLocation jarLocation = this.getJarLocation();
        this.getChunkSections().forEach((pos, section) -> {
            class_4076 sectionPos = class_4076.method_18677((long)pos);
            class_2841 blockStates = section.getBlockStates().method_39957();
            JarChunkUpdatePayload payload = new JarChunkUpdatePayload(jarLocation, sectionPos, (class_2841<class_2680>)blockStates);
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        });
    }

    public void sendJarChunk(class_3222 player, class_4076 sectionPos) {
        Networking.JarLocation jarLocation = this.getJarLocation();
        JarLevelChunkSection section = (JarLevelChunkSection)this.getChunkSections().get(sectionPos.method_18694());
        if (section == null) {
            return;
        }
        class_2841 blockStates = section.getBlockStates().method_39957();
        JarChunkUpdatePayload payload = new JarChunkUpdatePayload(jarLocation, sectionPos, (class_2841<class_2680>)blockStates);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    private Networking.JarLocation getJarLocation() {
        assert (this.field_11863 != null);
        return new Networking.JarLocation(this.method_11016(), (class_5321<class_1937>)this.field_11863.method_27983());
    }

    public class_8527 getChunk(int chunkX, int chunkZ) {
        long chunkPos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        return (class_8527)this.chunks.get(chunkPos);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.loadedNotPlaced = true;
        class_2487 modTag = tag.method_10562("worldinajar");
        this.scale = modTag.method_10550("scale");
        this.jarEntry = new JarEntry(modTag.method_10550("id"));
        this.internalSpawnPos = this.jarEntry.chunkPos().method_8323().method_10084();
        this.targetJarLocation = Networking.JarLocation.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)modTag.method_10580("target_jar_location")).result().orElse(null);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_2487 modTag = new class_2487();
        if (this.scale != 0) {
            modTag.method_10569("scale", this.scale);
        }
        modTag.method_10569("id", this.jarEntry.id());
        if (this.targetJarLocation != null) {
            Networking.JarLocation.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.targetJarLocation).result().ifPresent(target -> modTag.method_10566("target_jar_location", target));
        }
        tag.method_10566("worldinajar", (class_2520)modTag);
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        class_1273 lockKey = ((Accessor_BaseContainerBlockEntity)((Object)this)).getLockKey();
        super.method_57568(componentInput);
        ((Accessor_BaseContainerBlockEntity)((Object)this)).setLockKey(lockKey);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.worldinajar.world_jar");
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return class_2371.method_10211();
    }

    protected void method_11281(class_2371<class_1799> items) {
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return null;
    }

    public void method_11012() {
        super.method_11012();
        assert (this.field_11863 != null);
        if (!this.field_11863.method_8608()) {
            this.fakePlayers.forEach((uuid, fakePlayer) -> Main.removeKnownFakePlayerWithJar(this, (class_3218)this.field_11863, fakePlayer));
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.method_27983() == Dimensions.JAR) {
            return;
        }
        if (level.field_9236) {
            JarLevelLightEngine lightEngine = new JarLevelLightEngine(this, true, true);
            this.renderChunkRegion = new JarRenderChunkRegion(this, lightEngine);
            ClientPlayNetworking.send((class_8710)new JarLoadedPayload(this.getJarLocation()));
        } else {
            this.initializeServerChunks();
            if (!this.loadedNotPlaced) {
                for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new JarLoadedAckPayload(this.getJarLocation()));
                }
            }
        }
    }

    @Nullable
    public class_1937 method_10997() {
        return super.method_10997();
    }

    @Environment(value=EnvType.CLIENT)
    public void onChunkUpdate(class_310 client, class_4076 sectionPos, class_2841<class_2680> blockStateContainer) {
        client.execute(() -> {
            JarLevelChunkSection chunkSection = (JarLevelChunkSection)this.chunkSections.get(sectionPos.method_18694());
            class_1923 chunkPos = new class_1923(sectionPos.method_10263(), sectionPos.method_10260());
            JarChunk chunk = (JarChunk)this.chunks.get(chunkPos.method_8324());
            if (chunkSection == null) {
                chunkSection = new JarLevelChunkSection(sectionPos, true, blockStateContainer);
            } else {
                chunkSection.setBlockStates(blockStateContainer);
            }
            this.chunkSections.put(sectionPos.method_18694(), (Object)chunkSection);
            this.chunks.put(chunkPos.method_8324(), (Object)chunk);
            this.statesChanged = true;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void onBlockUpdate(class_310 client, class_2338 blockPos, class_2680 blockState) {
        client.execute(() -> {
            this.setBlockState(blockPos, blockState);
            this.statesChanged = true;
        });
    }

    public int getChunkDiameter() {
        return class_4076.method_32204((double)this.scale) + 1;
    }

    public Long2ObjectMap<JarLevelChunkSection> getChunkSections() {
        return this.chunkSections;
    }

    @Nullable
    public class_8527 method_12246(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ);
    }

    public class_2338 getInternalSpawnPos() {
        return this.internalSpawnPos;
    }

    public class_2338 getInternalPos() {
        return this.internalSpawnPos.method_10074();
    }

    @Override
    public boolean hasBlockPos(class_2338 pos) {
        return pos.method_19769((class_2374)this.getCenterPos(), (double)this.scale);
    }

    @NotNull
    public class_243 getCenterPos() {
        return this.getInternalPos().method_46558().method_1031((double)this.scale / 2.0, (double)this.scale / 2.0, (double)this.scale / 2.0);
    }

    public int method_5439() {
        return 0;
    }

    public Object2ObjectMap<UUID, FakePlayer> getFakePlayers() {
        return this.fakePlayers;
    }

    public FakePlayer getOrCreateFakePlayer(class_3218 outsideJarLevel, class_3222 player) {
        UUID uuid = UUID.nameUUIDFromBytes(player.method_5477().getString().getBytes(StandardCharsets.UTF_8));
        return (FakePlayer)this.fakePlayers.computeIfAbsent((Object)uuid, ignored -> FakePlayer.get((class_3218)outsideJarLevel, (GameProfile)new GameProfile(uuid, player.method_5477().getString())));
    }

    public static class WorldJarBlock
    extends class_2237 {
        private static final MapCodec<WorldJarBlock> CODEC = WorldJarBlock.method_54094(WorldJarBlock::new);

        public WorldJarBlock(class_4970.class_2251 properties) {
            super(properties);
            PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, blockEntity) -> !level.method_27983().equals(Dimensions.JAR) || !state.method_27852(Blocks.WORLD_JAR.block()));
        }

        @NotNull
        protected MapCodec<? extends class_2237> method_53969() {
            return CODEC;
        }

        @Nullable
        public class_2586 method_10123(class_2338 pos, class_2680 state) {
            return new WorldJarBlockEntity(pos, state);
        }

        protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
            super.method_9615(state, level, pos, oldState, movedByPiston);
        }

        @NotNull
        protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
            List drops = super.method_9560(state, params);
            class_2586 blockEntity = (class_2586)params.method_51876(class_181.field_1228);
            if (blockEntity instanceof WorldJarBlockEntity) {
                WorldJarBlockEntity jar = (WorldJarBlockEntity)blockEntity;
                ((class_1799)drops.getFirst()).method_57379(Components.JAR_ENTRY_TYPE, (Object)jar.jarEntry);
            }
            return drops;
        }

        @NotNull
        protected class_2464 method_9604(class_2680 state) {
            return class_2464.field_11458;
        }

        protected float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
            if (!player.method_37908().method_27983().equals(Dimensions.JAR)) {
                return super.method_9594(state, player, level, pos);
            }
            return 0.0f;
        }

        @NotNull
        protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
            if (class_7923.field_41178.method_10221((Object)stack.method_7909()).equals((Object)class_2960.method_60655((String)"glowcase", (String)"lock")) && player.method_7337()) {
                return class_9062.field_47729;
            }
            return super.method_55765(stack, state, level, pos, player, hand, hitResult);
        }

        @NotNull
        protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
            boolean isReturnJar = level.method_27983().equals(Dimensions.JAR);
            if (level.method_8608()) {
                if (!isReturnJar) {
                    ClientPlayNetworking.send((class_8710)new JarEnterPayload(new Networking.JarLocation(pos, (class_5321<class_1937>)level.method_27983())));
                }
                return class_1269.field_21466;
            }
            if (!isReturnJar) {
                return class_1269.field_5812;
            }
            MinecraftServer server = level.method_8503();
            assert (server != null);
            class_243 returnPos = ((PlayerWithReturn)player).worldinajar$getReturnPos();
            class_5321<class_1937> returnDim = ((PlayerWithReturn)player).worldinajar$getReturnDimension();
            Main.removeFakePlayer((class_3218)level, (class_3222)player);
            class_3218 returnLevel = server.method_3847(returnDim);
            class_5454 transition = new class_5454(returnLevel, returnPos, class_243.field_1353, 0.0f, 0.0f, class_5454.field_52245);
            player.method_5731(transition);
            return class_1269.field_5812;
        }
    }
}

