/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl.client.block.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import gay.sylv.wij.api.block.JarContainmentBlock;
import gay.sylv.wij.impl.block.entity.WorldJarBlockEntity;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.client.render.JarInternalsRenderer;
import gay.sylv.wij.impl.dimension.Dimensions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_750;
import net.minecraft.class_827;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class WorldJarRenderer
implements class_827<WorldJarBlockEntity> {
    private final class_5614.class_5615 context;
    private static final class_750 BYTE_BUFFER_BUILDERS = new class_750();
    private static final Map<class_1921, class_287> BUFFERS = new HashMap<class_1921, class_287>();

    public WorldJarRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public void render(WorldJarBlockEntity jar, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (jar.method_10997() != null && jar.method_10997().method_27983().equals(Dimensions.JAR)) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22905(jar.getVisualScale() - 0.001f, jar.getVisualScale() - 0.001f, jar.getVisualScale() - 0.001f);
        poseStack.method_46416(0.001f, 0.001f, 0.001f);
        if (jar.statesChanged) {
            jar.statesChanged = false;
            WorldJarRenderer.buildJar(this.context, jar);
        }
        WorldJarRenderer.renderJar(jar, poseStack);
        poseStack.method_22909();
    }

    public static void renderJar(WorldJarBlockEntity jar, class_4587 poseStack) {
        for (class_1921 renderType : class_1921.method_22720()) {
            renderType.method_23516();
            class_5944 shader = RenderSystem.getShader();
            Matrix4f frustumMatrix = poseStack.method_23760().method_23761();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.mul((Matrix4fc)frustumMatrix);
            Matrix4f modelView = new Matrix4f((Matrix4fc)matrix4fStack);
            jar.getChunkSections().forEach((pos, section) -> {
                if (section.isHasBuilt() && section.getRenderedTypes().contains((Object)renderType)) {
                    class_291 buffer = section.getVertexBuffers().get(renderType);
                    buffer.method_1353();
                    buffer.method_34427(modelView, RenderSystem.getProjectionMatrix(), shader);
                    class_291.method_1354();
                }
            });
            matrix4fStack.popMatrix();
            renderType.method_23518();
        }
    }

    public static void buildJar(class_5614.class_5615 context, WorldJarBlockEntity jar) {
        class_5819 randomSource = Objects.requireNonNull(jar.method_10997()).method_8409();
        class_4587 poseStack = new class_4587();
        jar.getChunkSections().forEach((pos, section) -> {
            class_2338 origin = section.getOrigin();
            class_2338 offset = new class_2338(15, 15, 15).method_10081((class_2382)origin);
            section.getRenderedTypes().clear();
            for (class_2338 blockPos : class_2338.method_10097((class_2338)origin, (class_2338)offset)) {
                class_287 bufferBuilder;
                class_1921 renderType;
                JarContainmentBlock containmentBlock;
                class_2680 state = jar.getBlockState(blockPos);
                class_2248 patt0$temp = state.method_26204();
                if (patt0$temp instanceof JarContainmentBlock && !(containmentBlock = (JarContainmentBlock)patt0$temp).renderInJar()) continue;
                class_3610 fluidState = state.method_26227();
                if (state.method_26164(BlockTags.NAUGHTY_BLOCKS)) continue;
                if (!fluidState.method_15769()) {
                    renderType = class_4696.method_23680((class_3610)fluidState);
                    section.getRenderedTypes().add((Object)renderType);
                    bufferBuilder = WorldJarRenderer.getOrSetBufferBuilder(renderType);
                    context.method_32141().method_3352(blockPos, (class_1920)jar.renderChunkRegion, (class_4588)bufferBuilder, state, fluidState);
                }
                if (state.method_26217() != class_2464.field_11458) continue;
                renderType = class_4696.method_23679((class_2680)state);
                section.getRenderedTypes().add((Object)renderType);
                bufferBuilder = WorldJarRenderer.getOrSetBufferBuilder(renderType);
                poseStack.method_22903();
                poseStack.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
                context.method_32141().method_3355(state, blockPos, (class_1920)jar.renderChunkRegion, poseStack, (class_4588)bufferBuilder, true, randomSource);
                poseStack.method_22909();
            }
            for (class_1921 renderType : section.getRenderedTypes()) {
                class_291 buffer = section.getVertexBuffers().get(renderType);
                class_287 bufferBuilder = BUFFERS.get(renderType);
                class_9801 renderedBuffer = bufferBuilder.method_60794();
                buffer.method_1353();
                buffer.method_1352(renderedBuffer);
                class_291.method_1354();
            }
            BUFFERS.clear();
            section.setHasBuilt(true);
        });
    }

    private static class_287 getOrSetBufferBuilder(class_1921 renderType) {
        return JarInternalsRenderer.getOrSetBufferBuilder(renderType, BUFFERS, BYTE_BUFFER_BUILDERS);
    }
}

