/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import gay.sylv.wij.impl.block.tag.BlockTags;
import gay.sylv.wij.impl.client.render.JarRenderChunkRegion;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.duck.RendererWithExternalBlockStates;
import gay.sylv.wij.impl.util.Initializable;
import gay.sylv.wij.impl.util.Instantiation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_4700;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_6539;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public final class JarInternalsRenderer
implements Initializable,
class_1920,
RendererWithExternalBlockStates {
    public static final JarInternalsRenderer INSTANCE = new JarInternalsRenderer();
    private static final class_750 BYTE_BUFFER_BUILDERS = new class_750();
    private static final Map<class_1921, class_287> BUFFERS = new HashMap<class_1921, class_287>();
    private final Map<class_6539, class_4700> tintCache = JarRenderChunkRegion.createTintCache(class_1163.field_5665, class_1163.field_5664, class_1163.field_5666);
    private class_2841<class_2680> externalBlockStateContainer = Instantiation.blockStatePalettedContainer();
    private final Map<class_1921, class_291> vertexBuffers = class_1921.method_22720().stream().collect(Collectors.toMap(key -> key, renderType -> new class_291(class_291.class_8555.field_44793)));
    private final Set<class_1921> renderedTypes = new HashSet<class_1921>();
    private class_243 jarCenter = new class_243(0.0, 0.0, 0.0);
    private boolean rebuild = false;

    private JarInternalsRenderer() {
    }

    @Override
    public void initialize() {
        WorldRenderEvents.BEFORE_ENTITIES.register(JarInternalsRenderer::buildAndRenderExternal);
    }

    private static void buildAndRenderExternal(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_37908().method_27983().equals(Dimensions.JAR)) {
            class_776 blockRenderer = client.method_1541();
            if (JarInternalsRenderer.INSTANCE.rebuild) {
                JarInternalsRenderer.INSTANCE.rebuild = false;
                JarInternalsRenderer.buildExternal(client, blockRenderer, JarInternalsRenderer.INSTANCE.externalBlockStateContainer);
            }
            class_4184 camera = context.camera();
            JarInternalsRenderer.renderExternal(context, camera, INSTANCE.worldinajar$getCenterOfJar(), new class_4587());
        }
    }

    private static void renderExternal(WorldRenderContext context, class_4184 camera, class_243 jarCenter, class_4587 poseStack) {
        poseStack.method_22903();
        class_243 distCenterToCamera = jarCenter.method_1020(camera.method_19326());
        poseStack.method_22904(distCenterToCamera.field_1352, distCenterToCamera.field_1351, distCenterToCamera.field_1350);
        poseStack.method_22905(64.0f, 64.0f, 64.0f);
        poseStack.method_22905(1.05f, 1.05f, 1.05f);
        poseStack.method_46416(-8.5f, -8.5f, -8.5f);
        for (class_1921 renderType : JarInternalsRenderer.INSTANCE.renderedTypes) {
            renderType.method_23516();
            class_5944 shader = RenderSystem.getShader();
            Matrix4f frustumMatrix = poseStack.method_23760().method_23761();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.mul((Matrix4fc)context.positionMatrix());
            matrix4fStack.mul((Matrix4fc)frustumMatrix);
            RenderSystem.applyModelViewMatrix();
            class_291 buffer = JarInternalsRenderer.INSTANCE.vertexBuffers.get(renderType);
            buffer.method_1353();
            buffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), shader);
            class_291.method_1354();
            matrix4fStack.popMatrix();
            renderType.method_23518();
        }
        poseStack.method_22909();
    }

    private static void buildExternal(class_310 client, class_776 blockRenderer, class_2841<class_2680> externalBlockStateContainer) {
        class_5819 randomSource = Objects.requireNonNull(client.field_1687, "Cannot build jar internals when Minecraft#level == null.").method_8409();
        class_2338 origin = new class_2338(0, 0, 0);
        class_2338 offset = new class_2338(15, 15, 15);
        class_2338 center = new class_2338(8, 8, 8);
        class_4587 poseStack = new class_4587();
        JarInternalsRenderer.INSTANCE.renderedTypes.clear();
        for (class_2338 blockPos : class_2338.method_10097((class_2338)origin, (class_2338)offset)) {
            class_287 bufferBuilder;
            class_1921 renderType;
            if (blockPos.equals((Object)center)) continue;
            class_2680 state = (class_2680)externalBlockStateContainer.method_12321(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            class_3610 fluidState = state.method_26227();
            if (state.method_26164(BlockTags.NAUGHTY_BLOCKS)) continue;
            if (!fluidState.method_15769()) {
                renderType = class_4696.method_23680((class_3610)fluidState);
                JarInternalsRenderer.INSTANCE.renderedTypes.add(renderType);
                bufferBuilder = JarInternalsRenderer.getOrSetBufferBuilder(renderType);
                blockRenderer.method_3352(blockPos, (class_1920)INSTANCE, (class_4588)bufferBuilder, state, fluidState);
            }
            if (state.method_26217() != class_2464.field_11458) continue;
            renderType = class_4696.method_23679((class_2680)state);
            JarInternalsRenderer.INSTANCE.renderedTypes.add(renderType);
            bufferBuilder = JarInternalsRenderer.getOrSetBufferBuilder(renderType);
            poseStack.method_22903();
            poseStack.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
            blockRenderer.method_3355(state, blockPos, (class_1920)INSTANCE, poseStack, (class_4588)bufferBuilder, true, randomSource);
            poseStack.method_22909();
        }
        for (class_1921 renderType : JarInternalsRenderer.INSTANCE.renderedTypes) {
            class_291 buffer = JarInternalsRenderer.INSTANCE.vertexBuffers.get(renderType);
            class_287 bufferBuilder = BUFFERS.get(renderType);
            class_9801 renderedBuffer = bufferBuilder.method_60794();
            buffer.method_1353();
            buffer.method_1352(renderedBuffer);
            class_291.method_1354();
        }
        BUFFERS.clear();
    }

    private static class_287 getOrSetBufferBuilder(class_1921 renderType) {
        return JarInternalsRenderer.getOrSetBufferBuilder(renderType, BUFFERS, BYTE_BUFFER_BUILDERS);
    }

    public static class_287 getOrSetBufferBuilder(class_1921 renderType, Map<class_1921, class_287> buffers, class_750 byteBufferBuilders) {
        if (!buffers.containsKey(renderType)) {
            class_9799 byteBufferBuilder = byteBufferBuilders.method_3154(renderType);
            class_287 bufferBuilder = new class_287(byteBufferBuilder, renderType.method_23033(), renderType.method_23031());
            buffers.put(renderType, bufferBuilder);
            return bufferBuilder;
        }
        return buffers.get(renderType);
    }

    public static void setRebuild(boolean rebuild) {
        JarInternalsRenderer.INSTANCE.rebuild = rebuild;
    }

    public float method_24852(class_2350 direction, boolean shade) {
        return Objects.requireNonNull(class_310.method_1551().field_1687).method_24852(direction, shade);
    }

    @NotNull
    public class_3568 method_22336() {
        return Objects.requireNonNull(class_310.method_1551().field_1687).method_22336();
    }

    public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
        return this.tintCache.get(colorResolver).method_23770(blockPos);
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        return null;
    }

    @NotNull
    public class_2680 method_8320(class_2338 pos) {
        if (pos.method_10263() > 15 || pos.method_10263() < 0 || pos.method_10264() > 15 || pos.method_10264() < 0 || pos.method_10260() > 15 || pos.method_10260() < 0) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)this.externalBlockStateContainer.method_12321(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @NotNull
    public class_3610 method_8316(class_2338 pos) {
        if (pos.method_10263() > 15 || pos.method_10263() < 0 || pos.method_10264() > 15 || pos.method_10264() < 0 || pos.method_10260() > 15 || pos.method_10260() < 0) {
            return class_2246.field_10124.method_9564().method_26227();
        }
        return ((class_2680)this.externalBlockStateContainer.method_12321(pos.method_10263(), pos.method_10264(), pos.method_10260())).method_26227();
    }

    public int method_31605() {
        return 16;
    }

    public int method_31607() {
        return -64;
    }

    @Override
    public class_2841<class_2680> worldinajar$getExternalBlockStateContainer() {
        return this.externalBlockStateContainer;
    }

    @Override
    public void worldinajar$setExternalBlockStateContainer(class_2841<class_2680> externalBlockStateContainer) {
        this.externalBlockStateContainer = externalBlockStateContainer;
    }

    @Override
    public class_243 worldinajar$getCenterOfJar() {
        return this.jarCenter;
    }

    @Override
    public void worldinajar$setCenterOfJar(class_243 centerOfJar) {
        this.jarCenter = centerOfJar;
    }
}

