/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl.datagen;

import gay.sylv.wij.api.block.BarkType;
import gay.sylv.wij.api.datagen.RuntimeResourcePack;
import gay.sylv.wij.impl.datagen.RuntimeResourcePackImpl;
import gay.sylv.wij.impl.item.BarkItem;
import gay.sylv.wij.impl.item.Items;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.Initializable;
import gay.sylv.wij.impl.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5253;
import net.minecraft.class_7367;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public final class DynamicDataGenerator
implements Initializable {
    public static final DynamicDataGenerator INSTANCE = new DynamicDataGenerator();

    private DynamicDataGenerator() {
    }

    @Override
    public void initialize() {
        BarkType.registerAll(BarkType.class);
    }

    @Environment(value=EnvType.CLIENT)
    public static final class TextureGenerator {
        private TextureGenerator() {
        }

        public static void generate(RuntimeResourcePack rrp, List<class_3262> resources) {
            class_1011 barkMask = TextureGenerator.getTexture(rrp, "bark.png");
            HashMap data = new HashMap();
            BarkType.getTypes().stream().map(type -> {
                class_1011 log;
                resources.forEach(packResources -> {
                    packResources.method_14408(class_3264.field_14188, type.toFilePath().method_12836(), type.toFilePath().method_12832(), data::put);
                    packResources.method_14408(class_3264.field_14188, type.toFilePath().method_12836(), type.toFilePath().method_48331(".mcmeta").method_12832(), data::put);
                });
                try {
                    log = class_1011.method_4309((InputStream)((InputStream)((class_7367)data.get(type.toFilePath())).get()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                class_1011 darkenedLog = TextureGenerator.multiplyBrightness(log, 0.85f);
                if (type.isAnimated()) {
                    try (InputStream inputStream = (InputStream)((class_7367)data.get(type.toFilePath().method_48331(".mcmeta"))).get();){
                        rrp.addItemMcmeta(type.getIdentifier(), new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                class_1011 expandedMask = TextureGenerator.expand(barkMask, log.method_4307(), log.method_4323());
                int shadowMask = class_5253.class_8045.method_48344((int)255, (int)0, (int)0, (int)255);
                TextureGenerator.maskImage(expandedMask, log);
                TextureGenerator.maskImage(log, darkenedLog, shadowMask);
                return new Pair<class_1011, BarkType>(darkenedLog, (BarkType)type);
            }).forEach(pair -> {
                class_1011 barkImage = (class_1011)pair.first();
                BarkType type = (BarkType)pair.second();
                rrp.addItemTexture(type.getIdentifier(), barkImage);
            });
        }

        @NotNull
        private static class_1011 getTexture(RuntimeResourcePack rrp, String texture) {
            class_1011 image;
            class_7367 inputStream = Objects.requireNonNull(rrp.method_14410(new String[]{texture}));
            try {
                image = class_1011.method_4309((InputStream)((InputStream)inputStream.get()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (image.method_4318() != class_1011.class_1012.field_4997) {
                TextureGenerator.throwError(texture);
            }
            return image;
        }

        private static void throwError(String maskName) {
            throw new RuntimeException("World In a Jar's runtime resource generation has failed due to an incorrect image format! Please check ensure that `src/main/resources/rrp/" + maskName + "` is in RGBA format.");
        }

        public static class_1011 expand(class_1011 mask, int width, int height) {
            if (width == mask.method_4307() && height == mask.method_4323()) {
                return mask;
            }
            class_1011 newMask = new class_1011(mask.method_4318(), width, height, false);
            int[] pixels = mask.method_48463();
            AtomicInteger index = new AtomicInteger();
            newMask.method_51596(pixel -> {
                int i = index.getAndIncrement();
                if (i + 1 > mask.method_4307() * mask.method_4323()) {
                    index.set(1);
                    i = 0;
                }
                return pixels[i];
            });
            return newMask;
        }

        public static class_1011 multiplyBrightness(class_1011 texture, float multiply) {
            return texture.method_48462(pixel -> {
                int red = class_5253.class_8045.method_48345((int)pixel);
                int green = class_5253.class_8045.method_48346((int)pixel);
                int blue = class_5253.class_8045.method_48347((int)pixel);
                int alpha = class_5253.class_8045.method_48342((int)pixel);
                return class_5253.class_8045.method_48344((int)alpha, (int)((int)((float)blue * multiply)), (int)((int)((float)green * multiply)), (int)((int)((float)red * multiply)));
            });
        }

        public static void maskImage(class_1011 mask, class_1011 texture) {
            TextureGenerator.maskImage(mask, texture, Constants.TEXTURE_MASK);
        }

        public static void maskImage(class_1011 mask, class_1011 texture, int maskColor) {
            int maskRed = class_5253.class_8045.method_48345((int)maskColor);
            int maskGreen = class_5253.class_8045.method_48346((int)maskColor);
            int maskBlue = class_5253.class_8045.method_48347((int)maskColor);
            int[] pixels = mask.method_48463();
            AtomicInteger index = new AtomicInteger();
            texture.method_51596(pixel -> {
                int i = index.getAndIncrement();
                int newRed = class_5253.class_8045.method_48345((int)pixel);
                int newGreen = class_5253.class_8045.method_48346((int)pixel);
                int newBlue = class_5253.class_8045.method_48347((int)pixel);
                int color = pixels[i];
                int red = class_5253.class_8045.method_48345((int)color);
                int green = class_5253.class_8045.method_48346((int)color);
                int blue = class_5253.class_8045.method_48347((int)color);
                int alpha = class_5253.class_8045.method_48342((int)color);
                if (red == maskRed && green == maskGreen && blue == maskBlue) {
                    return class_5253.class_8045.method_48344((int)alpha, (int)newBlue, (int)newGreen, (int)newRed);
                }
                return color;
            });
        }
    }

    public static final class ItemGenerator {
        private ItemGenerator() {
        }

        public static void registerBark(BarkType type) {
            class_1792 barkItem = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)type.getIdentifier(), (Object)((Object)new BarkItem(new class_1792.class_1793(), type)));
            Items.BARK.put(type, barkItem);
        }

        public static void generateBarkTag(BarkType type) {
            String generatedTag = RuntimeResourcePackImpl.generatedTag(List.of(type.getIdentifier()), false);
            RuntimeResourcePack.getInstance().addItemTag(Constants.modId("bark"), generatedTag);
        }

        public static void generateModel(BarkType type) {
            String model = type == BarkType.SPRUCE ? String.format("{\n\t\"parent\": \"item/generated\",\n\t\"textures\": {\n\t\t\"layer0\": \"%1$s\"\n\t},\n\t\"overrides\": [\n \t\t{\n \t\t\t\"predicate\": {\n \t\t\t\t\"custom_model_data\": 1\n \t\t\t},\n \t\t\t\"model\": \"minecraft:item/cooked_beef\"\n \t\t}\n \t]\n}\n", type.getResourceIdentifier("item")) : ItemGenerator.generatedModel(type.getResourceIdentifier("item"));
            RuntimeResourcePack.getInstance().addModel(type.getResourceIdentifier("item"), model);
        }

        private static String generatedModel(class_2960 id) {
            return String.format("{\n\t\"parent\": \"item/generated\",\n\t\"textures\": {\n\t\t\"layer0\": \"%1$s\"\n\t}\n}\n", id.toString());
        }
    }
}

