/*
 * Decompiled with CFR 0.152.
 */
package gay.sylv.wij.impl.util.jar;

import gay.sylv.wij.impl.Main;
import gay.sylv.wij.impl.block.Blocks;
import gay.sylv.wij.impl.dimension.Dimensions;
import gay.sylv.wij.impl.util.Assertions;
import gay.sylv.wij.impl.util.Constants;
import gay.sylv.wij.impl.util.jar.JarEntries;
import gay.sylv.wij.impl.util.jar.JarEntry;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarPlacer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"worldinajar/JarPlacer");
    private static JarPlacer instance = null;
    private final MinecraftServer server;

    private JarPlacer(MinecraftServer server) {
        this.server = server;
    }

    private JarEntries getJarEntries() {
        return (JarEntries)Objects.requireNonNull(this.server.method_3847(Dimensions.JAR), "Jar dimension must exist.").method_17983().method_17924(JarEntries.factory(), "worldinajar_jar_data");
    }

    @NotNull
    public static JarPlacer getInstance() {
        return Objects.requireNonNull(instance, "JarPlacer must be initialized.");
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static void initialize(MinecraftServer server) throws IllegalAccessException {
        Assertions.checkCaller(Main.class);
        instance = new JarPlacer(server);
    }

    public static void clear() throws IllegalAccessException {
        Assertions.checkCaller(Main.class);
        instance = null;
    }

    @NotNull
    public JarEntry getFreeJarEntry() {
        return this.getJarEntries().getFreeJarEntry();
    }

    public boolean jarExists(JarEntry jarEntry, class_3218 level) {
        return !level.method_8320(jarEntry.chunkPos().method_8323()).method_26215();
    }

    public void placeJar(JarEntry jarEntry) {
        class_3218 level = Objects.requireNonNull(this.server.method_3847(Dimensions.JAR), "Jar dimension must exist.");
        if (!this.jarExists(jarEntry, level)) {
            class_3485 structureManager = level.method_14183();
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        class_3499 structureTemplate = (class_3499)structureManager.method_15094(Constants.modId("jar-" + x + "-" + y + "-" + z)).orElseThrow();
                        if (structureTemplate.method_15172((class_5425)level, jarEntry.chunkPos().method_8323().method_10069(-1, -1, -1).method_10069(x * 48, y * 48, z * 48), class_2338.field_10980, new class_3492(), level.field_9229, 3)) continue;
                        LOGGER.error("Failed to place jar in jar dimension!");
                    }
                }
            }
            level.method_8652(jarEntry.chunkPos().method_8323(), Blocks.WORLD_JAR.block().method_9564(), 3);
        }
    }
}

