/*
 * Decompiled with CFR 0.152.
 */
package xyz.joyedforlife.joyedwarps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Joyedwarps
extends JavaPlugin
implements TabCompleter {
    private File warpsFile;
    private FileConfiguration warpsConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadWarps();
        this.getCommand("warp").setExecutor(this::warpCommand);
        this.getCommand("warps").setExecutor(this::warpsListCommand);
        this.getCommand("warpsadmin").setExecutor(this::warpsAdminCommand);
        this.getCommand("warpsadmin").setTabCompleter((TabCompleter)this);
    }

    public void loadWarps() {
        this.warpsFile = new File(this.getDataFolder(), "warps.yml");
        if (!this.warpsFile.exists()) {
            this.saveResource("warps.yml", false);
        }
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
    }

    public void saveWarps() {
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPrefix() {
        return this.getConfig().getString("prefix", "&6[JoyedWarps]&r ");
    }

    public String format(String msg) {
        return msg.replace("&", "\u00a7");
    }

    private boolean warpExists(String name) {
        return this.warpsConfig.contains("warps." + name);
    }

    private void setWarp(String name, Location loc) {
        this.warpsConfig.set("warps." + name + ".world", (Object)loc.getWorld().getName());
        this.warpsConfig.set("warps." + name + ".x", (Object)loc.getX());
        this.warpsConfig.set("warps." + name + ".y", (Object)loc.getY());
        this.warpsConfig.set("warps." + name + ".z", (Object)loc.getZ());
        this.warpsConfig.set("warps." + name + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.warpsConfig.set("warps." + name + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.warpsConfig.set("warps." + name + ".locked", (Object)false);
        this.warpsConfig.set("warps." + name + ".permission", null);
        this.saveWarps();
    }

    private void deleteWarp(String name) {
        this.warpsConfig.set("warps." + name, null);
        this.saveWarps();
    }

    private void renameWarp(String oldName, String newName) {
        if (!this.warpExists(oldName)) {
            return;
        }
        this.warpsConfig.set("warps." + newName, (Object)this.warpsConfig.getConfigurationSection("warps." + oldName));
        this.deleteWarp(oldName);
        this.saveWarps();
    }

    private void setWarpPermission(String name, String permission) {
        if (!this.warpExists(name)) {
            return;
        }
        this.warpsConfig.set("warps." + name + ".permission", (Object)permission);
        this.saveWarps();
    }

    private void lockWarp(String name) {
        if (!this.warpExists(name)) {
            return;
        }
        this.warpsConfig.set("warps." + name + ".locked", (Object)true);
        this.saveWarps();
    }

    private void unlockWarp(String name) {
        if (!this.warpExists(name)) {
            return;
        }
        this.warpsConfig.set("warps." + name + ".locked", (Object)false);
        this.saveWarps();
    }

    private Location getWarpLocation(String name) {
        if (!this.warpExists(name)) {
            return null;
        }
        String worldName = this.warpsConfig.getString("warps." + name + ".world");
        World world = Bukkit.getWorld((String)worldName);
        double x = this.warpsConfig.getDouble("warps." + name + ".x");
        double y = this.warpsConfig.getDouble("warps." + name + ".y");
        double z = this.warpsConfig.getDouble("warps." + name + ".z");
        float yaw = (float)this.warpsConfig.getDouble("warps." + name + ".yaw");
        float pitch = (float)this.warpsConfig.getDouble("warps." + name + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    private boolean isWarpLocked(String name) {
        return this.warpsConfig.getBoolean("warps." + name + ".locked", false);
    }

    private String getWarpPermission(String name) {
        return this.warpsConfig.getString("warps." + name + ".permission");
    }

    private List<String> getAllWarpNames() {
        if (!this.warpsConfig.contains("warps")) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.warpsConfig.getConfigurationSection("warps").getKeys(false));
    }

    private boolean warpCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.format(this.getPrefix() + "&cOnly players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(this.format(this.getPrefix() + "&cUsage: /warp <name>"));
            return true;
        }
        String warpName = args[0];
        if (!this.warpExists(warpName)) {
            player.sendMessage(this.format(this.getPrefix() + "&cWarp &e" + warpName + "&c does not exist!"));
            return true;
        }
        if (this.isWarpLocked(warpName) && !player.hasPermission("joyedwarps.admin")) {
            player.sendMessage(this.format(this.getPrefix() + "&cThis warp is locked! Only admins can use it."));
            return true;
        }
        String perm = this.getWarpPermission(warpName);
        if (perm != null && !perm.isEmpty() && !player.hasPermission(perm)) {
            player.sendMessage(this.format(this.getPrefix() + "&cYou don't have permission to use this warp!"));
            return true;
        }
        Location loc = this.getWarpLocation(warpName);
        player.teleport(loc);
        player.sendMessage(this.format(this.getPrefix() + "&aTeleported to &e" + warpName + "&a!"));
        return true;
    }

    private boolean warpsListCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.format(this.getPrefix() + "&cOnly players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        ArrayList<String> warps = new ArrayList<String>();
        for (String w : this.getAllWarpNames()) {
            String perm = this.getWarpPermission(w);
            boolean locked = this.isWarpLocked(w);
            if (locked && !player.hasPermission("joyedwarps.admin") || perm != null && !perm.isEmpty() && !player.hasPermission(perm)) continue;
            warps.add(w);
        }
        player.sendMessage(this.format(this.getPrefix() + "&eAvailable warps: &a" + String.join((CharSequence)", ", warps)));
        return true;
    }

    private boolean warpsAdminCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.format(this.getPrefix() + "&cOnly players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("joyedwarps.admin")) {
            player.sendMessage(this.format(this.getPrefix() + "&cYou don't have permission!"));
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(this.format(this.getPrefix() + "&cUsage: /warpsadmin <create|delete|permission|lock|unlock|rename|reload> <warpName> [other]"));
            return true;
        }
        String type = args[0].toLowerCase();
        if (type.equals("reload")) {
            this.reloadConfig();
            this.loadWarps();
            player.sendMessage(this.format(this.getPrefix() + "&aJoyedWarps has been reloaded!"));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.format(this.getPrefix() + "&cUsage: /warpsadmin <create|delete|permission|lock|unlock|rename> <warpName> [other]"));
            return true;
        }
        String warpName = args[1];
        switch (type) {
            case "create": {
                if (this.warpExists(warpName)) {
                    player.sendMessage(this.format(this.getPrefix() + "&cWarp already exists!"));
                    return true;
                }
                this.setWarp(warpName, player.getLocation());
                player.sendMessage(this.format(this.getPrefix() + "&aWarp &e" + warpName + "&a created!"));
                break;
            }
            case "delete": {
                if (!this.warpExists(warpName)) {
                    player.sendMessage(this.format(this.getPrefix() + "&cWarp does not exist!"));
                    return true;
                }
                this.deleteWarp(warpName);
                player.sendMessage(this.format(this.getPrefix() + "&cWarp &e" + warpName + "&c deleted!"));
                break;
            }
            case "permission": {
                if (args.length < 3) {
                    player.sendMessage(this.format(this.getPrefix() + "&cUsage: /warpsadmin permission <warpName> <permission>"));
                    return true;
                }
                String perm = args[2];
                this.setWarpPermission(warpName, perm);
                player.sendMessage(this.format(this.getPrefix() + "&aPermission &e" + perm + "&a set for warp &e" + warpName + "&a!"));
                break;
            }
            case "lock": {
                this.lockWarp(warpName);
                player.sendMessage(this.format(this.getPrefix() + "&cWarp &e" + warpName + "&c is now locked! Only admins can teleport."));
                break;
            }
            case "unlock": {
                this.unlockWarp(warpName);
                player.sendMessage(this.format(this.getPrefix() + "&aWarp &e" + warpName + "&a is now unlocked!"));
                break;
            }
            case "rename": {
                if (args.length < 3) {
                    player.sendMessage(this.format(this.getPrefix() + "&cUsage: /warpsadmin rename <warpName> <newName>"));
                    return true;
                }
                String newName = args[2];
                this.renameWarp(warpName, newName);
                player.sendMessage(this.format(this.getPrefix() + "&aWarp &e" + warpName + "&a renamed to &e" + newName + "&a!"));
                break;
            }
            default: {
                player.sendMessage(this.format(this.getPrefix() + "&cUnknown type!"));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("warpsadmin")) {
            if (args.length == 1) {
                completions.addAll(List.of("create", "delete", "permission", "lock", "unlock", "rename", "reload"));
            } else if (args.length == 2 && !args[0].equalsIgnoreCase("create")) {
                completions.addAll(this.getAllWarpNames());
            }
        }
        return completions;
    }
}

