/*
 * Decompiled with CFR 0.152.
 */
package xyz.joyedforlife.joyedwarps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class Joyedwarps
extends JavaPlugin
implements Listener,
TabExecutor,
TabCompleter {
    private File warpsFile;
    private FileConfiguration warpsConfig;
    private Economy econ = null;
    private final Map<UUID, BukkitTask> pendingTeleportTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> pendingCountdownTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Location> teleportStartLocation = new ConcurrentHashMap<UUID, Location>();

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.warpsFile = new File(this.getDataFolder(), "warps.yml");
        if (!this.warpsFile.exists()) {
            this.saveResource("warps.yml", false);
        }
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
        this.setupVault();
        Objects.requireNonNull(this.getCommand("warp")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("warp")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("warps")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("warps")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("warpsadmin")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("warpsadmin")).setTabCompleter((TabCompleter)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("JoyedWarps enabled.");
    }

    public void onDisable() {
        this.pendingTeleportTasks.values().forEach(BukkitTask::cancel);
        this.pendingCountdownTasks.values().forEach(BukkitTask::cancel);
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getLogger().info("JoyedWarps disabled.");
    }

    private void setupVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.econ = null;
            this.getLogger().info("Vault not found - economy features disabled.");
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            this.econ = (Economy)rsp.getProvider();
            this.getLogger().info("Vault connected - economy features enabled.");
        } else {
            this.econ = null;
            this.getLogger().info("Vault present but no economy provider found.");
        }
    }

    private boolean warpExists(String name) {
        return this.warpsConfig.contains("warps." + name);
    }

    private Set<String> getAllWarpNames() {
        if (!this.warpsConfig.contains("warps")) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(this.warpsConfig.getConfigurationSection("warps").getKeys(false));
    }

    private Location getWarpLocation(String name) {
        if (!this.warpExists(name)) {
            return null;
        }
        String base = "warps." + name + ".";
        String world = this.warpsConfig.getString(base + "world", null);
        if (world == null) {
            return null;
        }
        if (Bukkit.getWorld((String)world) == null) {
            return null;
        }
        double x = this.warpsConfig.getDouble(base + "x");
        double y = this.warpsConfig.getDouble(base + "y");
        double z = this.warpsConfig.getDouble(base + "z");
        float yaw = (float)this.warpsConfig.getDouble(base + "yaw");
        float pitch = (float)this.warpsConfig.getDouble(base + "pitch");
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    private Material getWarpIcon(String name) {
        String mat = this.warpsConfig.getString("warps." + name + ".icon", "ENDER_PEARL");
        Material m = Material.matchMaterial((String)mat);
        return m != null ? m : Material.ENDER_PEARL;
    }

    private int getWarpWait(String name) {
        return this.warpsConfig.getInt("warps." + name + ".wait", this.getConfig().getInt("default-wait", 5));
    }

    private double getWarpCost(String name) {
        return this.warpsConfig.getDouble("warps." + name + ".cost", 0.0);
    }

    private boolean isWarpLocked(String name) {
        return this.warpsConfig.getBoolean("warps." + name + ".locked", false);
    }

    private String getWarpDescription(String name) {
        return this.warpsConfig.getString("warps." + name + ".description", "");
    }

    private void setWarp(String name, Location loc) {
        String base = "warps." + name + ".";
        this.warpsConfig.set(base + "world", (Object)loc.getWorld().getName());
        this.warpsConfig.set(base + "x", (Object)loc.getX());
        this.warpsConfig.set(base + "y", (Object)loc.getY());
        this.warpsConfig.set(base + "z", (Object)loc.getZ());
        this.warpsConfig.set(base + "yaw", (Object)Float.valueOf(loc.getYaw()));
        this.warpsConfig.set(base + "pitch", (Object)Float.valueOf(loc.getPitch()));
        if (!this.warpsConfig.contains("warps." + name + ".icon")) {
            this.warpsConfig.set(base + "icon", (Object)"ENDER_PEARL");
        }
        if (!this.warpsConfig.contains("warps." + name + ".wait")) {
            this.warpsConfig.set(base + "wait", (Object)this.getConfig().getInt("default-wait", 5));
        }
        if (!this.warpsConfig.contains("warps." + name + ".cost")) {
            this.warpsConfig.set(base + "cost", (Object)0.0);
        }
        if (!this.warpsConfig.contains("warps." + name + ".locked")) {
            this.warpsConfig.set(base + "locked", (Object)false);
        }
        this.saveWarps();
    }

    private void deleteWarp(String name) {
        this.warpsConfig.set("warps." + name, null);
        this.saveWarps();
    }

    private void renameWarp(String oldName, String newName) {
        if (!this.warpExists(oldName)) {
            return;
        }
        this.warpsConfig.set("warps." + newName, (Object)this.warpsConfig.getConfigurationSection("warps." + oldName));
        this.warpsConfig.set("warps." + oldName, null);
        this.saveWarps();
    }

    private void setWarpIcon(String name, String materialName) {
        this.warpsConfig.set("warps." + name + ".icon", (Object)materialName);
        this.saveWarps();
    }

    private void setWarpWait(String name, int seconds) {
        this.warpsConfig.set("warps." + name + ".wait", (Object)seconds);
        this.saveWarps();
    }

    private void setWarpCost(String name, double cost) {
        this.warpsConfig.set("warps." + name + ".cost", (Object)cost);
        this.saveWarps();
    }

    private void setWarpLock(String name, boolean locked) {
        this.warpsConfig.set("warps." + name + ".locked", (Object)locked);
        this.saveWarps();
    }

    private void setWarpDescription(String name, String desc) {
        this.warpsConfig.set("warps." + name + ".description", (Object)desc);
        this.saveWarps();
    }

    private void saveWarps() {
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Could not save warps.yml: " + e.getMessage());
        }
    }

    private void startWarpWithWait(final Player player, final String warpName) {
        if (!this.warpExists(warpName)) {
            player.sendMessage(this.prefixMsg("&cWarp does not exist."));
            return;
        }
        final double cost = this.getWarpCost(warpName);
        final boolean hasFree = player.hasPermission("joyedwarps.free." + warpName);
        if (cost > 0.0 && this.econ != null && !hasFree && !this.econ.has((OfflinePlayer)player, cost)) {
            player.sendMessage(this.prefixMsg("&cYou don't have enough money to warp (cost: " + cost + ")."));
            return;
        }
        int wait = this.getWarpWait(warpName);
        if (wait <= 0) {
            this.completeWarp(player, warpName, cost, hasFree);
            return;
        }
        this.cancelPendingWarp(player.getUniqueId());
        this.teleportStartLocation.put(player.getUniqueId(), player.getLocation().clone());
        final int total = wait;
        final UUID uid = player.getUniqueId();
        BukkitTask countdown = Bukkit.getScheduler().runTaskTimer((Plugin)this, new Runnable(){
            int remaining;
            {
                this.remaining = total;
            }

            @Override
            public void run() {
                if (!player.isOnline()) {
                    Joyedwarps.this.cancelPendingWarp(uid);
                    return;
                }
                Location start = Joyedwarps.this.teleportStartLocation.get(uid);
                if (start != null && Joyedwarps.this.hasPlayerMoved(player, start)) {
                    player.sendMessage(Joyedwarps.this.prefixMsg("&cWarp cancelled because you moved!"));
                    player.resetTitle();
                    Joyedwarps.this.cancelPendingWarp(uid);
                    return;
                }
                player.sendTitle(String.valueOf(ChatColor.YELLOW) + "Warping in " + this.remaining + "...", "", 0, 20, 0);
                --this.remaining;
                if (this.remaining < 0) {
                    Joyedwarps.this.cancelPendingWarp(uid);
                    Joyedwarps.this.completeWarp(player, warpName, cost, hasFree);
                }
            }
        }, 0L, 20L);
        this.pendingCountdownTasks.put(player.getUniqueId(), countdown);
        BukkitTask placeholder = Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {}, (long)wait * 20L);
        this.pendingTeleportTasks.put(player.getUniqueId(), placeholder);
        player.sendMessage(this.prefixMsg(this.getConfig().getString("messages.warp-wait", "&eWarping to %warp% in %time% seconds...").replace("%warp%", warpName).replace("%time%", String.valueOf(wait))));
    }

    private void completeWarp(Player player, String warpName, double cost, boolean hasFree) {
        Location loc;
        if (cost > 0.0 && this.econ != null && !hasFree) {
            this.econ.withdrawPlayer((OfflinePlayer)player, cost);
        }
        if ((loc = this.getWarpLocation(warpName)) == null) {
            player.sendMessage(this.prefixMsg("&cWarp destination world not found."));
            return;
        }
        player.teleport(loc);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.sendTitle(String.valueOf(ChatColor.GREEN) + "Teleported!", "", 5, 40, 5);
        player.sendMessage(this.prefixMsg(this.getConfig().getString("messages.warp-success", "&aWarped to %warp%!").replace("%warp%", warpName)));
    }

    private void cancelPendingWarp(UUID uid) {
        if (this.pendingTeleportTasks.containsKey(uid)) {
            this.pendingTeleportTasks.get(uid).cancel();
            this.pendingTeleportTasks.remove(uid);
        }
        if (this.pendingCountdownTasks.containsKey(uid)) {
            this.pendingCountdownTasks.get(uid).cancel();
            this.pendingCountdownTasks.remove(uid);
        }
        this.teleportStartLocation.remove(uid);
    }

    private boolean hasPlayerMoved(Player p, Location start) {
        Location now = p.getLocation();
        return now.getBlockX() != start.getBlockX() || now.getBlockY() != start.getBlockY() || now.getBlockZ() != start.getBlockZ();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefixMsg("&cOnly players can use this command."));
            return true;
        }
        Player p = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("warp")) {
            if (args.length < 1) {
                p.sendMessage(this.prefixMsg("&cUsage: /warp <name>"));
                return true;
            }
            String warpName = args[0];
            if (!this.warpExists(warpName)) {
                p.sendMessage(this.prefixMsg(this.getConfig().getString("messages.warp-not-found", "&cWarp %warp% does not exist.").replace("%warp%", warpName)));
                return true;
            }
            if (this.isWarpLocked(warpName) && !p.hasPermission("joyedwarps.admin")) {
                p.sendMessage(this.prefixMsg(this.getConfig().getString("messages.warp-locked", "&cThis warp is locked!")));
                return true;
            }
            this.startWarpWithWait(p, warpName);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("warps")) {
            this.openWarpsGUI(p);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("warpsadmin")) {
            String sub;
            if (!p.hasPermission("joyedwarps.admin")) {
                p.sendMessage(this.prefixMsg(this.getConfig().getString("messages.admin-no-perm", "&cYou don't have permission.")));
                return true;
            }
            if (args.length < 1) {
                p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin <create|delete|rename|lock|unlock|icon|wait|cost|reload>"));
                return true;
            }
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "create": {
                    if (args.length < 2) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin create <name>"));
                        return true;
                    }
                    String name = args[1];
                    if (this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp already exists."));
                        return true;
                    }
                    this.setWarp(name, p.getLocation());
                    p.sendMessage(this.prefixMsg("&aWarp &e" + name + "&a created."));
                    break;
                }
                case "delete": {
                    if (args.length < 2) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin delete <name>"));
                        return true;
                    }
                    String name = args[1];
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    this.deleteWarp(name);
                    p.sendMessage(this.prefixMsg("&cWarp &e" + name + "&c deleted."));
                    break;
                }
                case "rename": {
                    if (args.length < 3) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin rename <old> <new>"));
                        return true;
                    }
                    String oldName = args[1];
                    String newName = args[2];
                    if (!this.warpExists(oldName)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    if (this.warpExists(newName)) {
                        p.sendMessage(this.prefixMsg("&cTarget name already exists."));
                        return true;
                    }
                    this.renameWarp(oldName, newName);
                    p.sendMessage(this.prefixMsg("&aRenamed &e" + oldName + " &ato &e" + newName));
                    break;
                }
                case "lock": {
                    if (args.length < 2) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin lock <name>"));
                        return true;
                    }
                    String name = args[1];
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    this.setWarpLock(name, true);
                    p.sendMessage(this.prefixMsg("&cWarp &e" + name + " &clocked."));
                    break;
                }
                case "unlock": {
                    if (args.length < 2) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin unlock <name>"));
                        return true;
                    }
                    String name = args[1];
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    this.setWarpLock(name, false);
                    p.sendMessage(this.prefixMsg("&aWarp &e" + name + " &aunlocked."));
                    break;
                }
                case "icon": {
                    if (args.length < 3) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin icon <name> <MATERIAL>"));
                        return true;
                    }
                    String name = args[1];
                    String mat = args[2].toUpperCase(Locale.ROOT);
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    Material m = Material.matchMaterial((String)mat);
                    if (m == null) {
                        p.sendMessage(this.prefixMsg("&cInvalid material."));
                        return true;
                    }
                    this.setWarpIcon(name, m.name());
                    p.sendMessage(this.prefixMsg("&aIcon set for &e" + name + "&a to &e" + m.name()));
                    break;
                }
                case "wait": {
                    if (args.length < 3) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin wait <name> <seconds>"));
                        return true;
                    }
                    String name = args[1];
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    try {
                        int secs = Integer.parseInt(args[2]);
                        this.setWarpWait(name, secs);
                        p.sendMessage(this.prefixMsg("&aWait set for &e" + name + " &ato &e" + secs + "s"));
                    }
                    catch (NumberFormatException ex) {
                        p.sendMessage(this.prefixMsg("&cInvalid number."));
                    }
                    break;
                }
                case "cost": {
                    if (args.length < 3) {
                        p.sendMessage(this.prefixMsg("&cUsage: /warpsadmin cost <name> <amount>"));
                        return true;
                    }
                    String name = args[1];
                    if (!this.warpExists(name)) {
                        p.sendMessage(this.prefixMsg("&cWarp does not exist."));
                        return true;
                    }
                    try {
                        double amt = Double.parseDouble(args[2]);
                        this.setWarpCost(name, amt);
                        p.sendMessage(this.prefixMsg("&aCost for &e" + name + " &aset to &e" + amt));
                    }
                    catch (NumberFormatException ex) {
                        p.sendMessage(this.prefixMsg("&cInvalid number."));
                    }
                    break;
                }
                case "reload": {
                    this.reloadConfig();
                    this.warpsFile = new File(this.getDataFolder(), "warps.yml");
                    this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
                    p.sendMessage(this.prefixMsg("&aConfiguration and warps reloaded."));
                    break;
                }
                default: {
                    p.sendMessage(this.prefixMsg("&cUnknown subcommand."));
                }
            }
            return true;
        }
        return false;
    }

    private void openWarpsGUI(Player p) {
        if (!this.warpsConfig.contains("warps")) {
            p.sendMessage(this.prefixMsg("&cNo warps defined."));
            return;
        }
        Set<String> names = this.getAllWarpNames();
        int size = Math.min(54, (names.size() + 8) / 9 * 9);
        if (size == 0) {
            size = 9;
        }
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.format(this.getConfig().getString("gui-settings.warps-title", "&bAvailable Warps")));
        for (String name : names) {
            Material mat = this.getWarpIcon(name);
            ItemStack item = new ItemStack(mat);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                double cost;
                meta.setDisplayName(this.format("&a" + name));
                ArrayList<String> lore = new ArrayList<String>();
                String desc = this.getWarpDescription(name);
                if (desc != null && !desc.isEmpty()) {
                    lore.add(this.format("&7" + desc));
                }
                if ((cost = this.getWarpCost(name)) > 0.0) {
                    lore.add(this.format("&7Cost: &e" + cost));
                }
                lore.add(this.format("&7Wait: &e" + this.getWarpWait(name) + "s"));
                lore.add(this.isWarpLocked(name) ? this.format("&cLocked") : this.format("&aUnlocked"));
                lore.add(this.format("&eClick to warp"));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.addItem(new ItemStack[]{item});
        }
        p.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        String expectedTitle;
        HumanEntity clicker = e.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        String title = e.getView().getTitle();
        if (!title.equals(expectedTitle = this.format(this.getConfig().getString("gui-settings.warps-title", "&bAvailable Warps")))) {
            return;
        }
        e.setCancelled(true);
        ItemStack current = e.getCurrentItem();
        if (current == null || !current.hasItemMeta()) {
            return;
        }
        String display = current.getItemMeta().getDisplayName();
        if (display == null || display.isEmpty()) {
            return;
        }
        String warpName = ChatColor.stripColor((String)display);
        if (!this.warpExists(warpName)) {
            player.sendMessage(this.prefixMsg("&cWarp not found."));
            return;
        }
        this.startWarpWithWait(player, warpName);
        player.closeInventory();
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        String expectedTitle;
        HumanEntity dragger = e.getWhoClicked();
        if (!(dragger instanceof Player)) {
            return;
        }
        Player p = (Player)dragger;
        String title = e.getView().getTitle();
        if (title.equals(expectedTitle = this.format(this.getConfig().getString("gui-settings.warps-title", "&bAvailable Warps")))) {
            e.setCancelled(true);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("warp") && args.length == 1 && this.warpsConfig.contains("warps")) {
            String part = args[0].toLowerCase(Locale.ROOT);
            return this.getAllWarpNames().stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(part)).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("warpsadmin")) {
            if (args.length == 1) {
                return Arrays.asList("create", "delete", "rename", "lock", "unlock", "icon", "wait", "cost", "reload").stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 2 && this.warpsConfig.contains("warps")) {
                String part = args[1].toLowerCase(Locale.ROOT);
                return this.getAllWarpNames().stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(part)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private String prefixMsg(String raw) {
        String prefix = this.getConfig().getString("prefix", "&7[&bJoyedWarps&7] ");
        return this.format(prefix + raw);
    }

    private String prefixPlain(String raw) {
        String prefix = this.getConfig().getString("prefix", "&7[&bJoyedWarps&7] ");
        return ChatColor.stripColor((String)this.format(prefix + raw));
    }

    private String format(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

