/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers;

import com.benbenlaw.core.fluid.FluidDeferredRegister;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.config.StrainersConfigFile;
import com.benbenlaw.strainers.fluid.StrainersFluids;
import com.benbenlaw.strainers.item.ModCreativeTab;
import com.benbenlaw.strainers.item.ModItems;
import com.benbenlaw.strainers.item.StrainersDataComponents;
import com.benbenlaw.strainers.recipe.ModRecipes;
import com.benbenlaw.strainers.screen.ModMenuTypes;
import com.benbenlaw.strainers.screen.custom.CompactorScreen;
import com.benbenlaw.strainers.screen.custom.WoodenStrainerScreen;
import com.benbenlaw.strainers.util.StrainersColorHandler;
import com.benbenlaw.strainers.util.StrainersIngredientDurations;
import java.util.List;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="strainers")
public class Strainers {
    public static final String MOD_ID = "strainers";
    private static final Logger LOGGER = LogManager.getLogger();

    public Strainers(IEventBus modEventBus) {
        ModItems.register(modEventBus);
        StrainersDataComponents.COMPONENTS.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeTab.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        StrainersFluids.FLUIDS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.register((Object)new StrainersColorHandler());
        }
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StrainersConfigFile.SPEC, "bbl/strainers/startup.toml");
        StrainersIngredientDurations.loadItemDurationsFromConfig((List)StrainersConfigFile.blockDurations.get());
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ModBlockEntities.registerCapabilities(event);
    }

    public void commonSetup(RegisterPayloadHandlersEvent event) {
    }

    @EventBusSubscriber(modid="strainers")
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.WOODEN_STRAINER_MENU.get(), WoodenStrainerScreen::new);
            event.register((MenuType)ModMenuTypes.COMPACTOR_MENU.get(), CompactorScreen::new);
        }

        @SubscribeEvent
        public static void onClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerFluidType(((FluidDeferredRegister.CoreFluidTypes)StrainersFluids.ERODING_WATER.getFluidType()).getClientExtensions(), new FluidType[]{StrainersFluids.ERODING_WATER.getFluidType()});
            event.registerFluidType(((FluidDeferredRegister.CoreFluidTypes)StrainersFluids.PURIFYING_WATER.getFluidType()).getClientExtensions(), new FluidType[]{StrainersFluids.PURIFYING_WATER.getFluidType()});
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {});
        }
    }
}

