/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.benbenlaw.strainers.item.custom.UpgradeItem;
import com.benbenlaw.strainers.recipe.MeshChanceResult;
import com.benbenlaw.strainers.recipe.ModRecipes;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.benbenlaw.strainers.recipe.StrainerRecipeInput;
import com.benbenlaw.strainers.screen.custom.WoodenStrainerMenu;
import com.benbenlaw.strainers.util.ModTags;
import com.benbenlaw.strainers.util.StrainersIngredientDurations;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenStrainerBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(38){

        protected void onContentsChanged(int slot) {
            WoodenStrainerBlockEntity.this.setChanged();
            WoodenStrainerBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 2 || slot == 3 || slot == 4 || slot == 1) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }

        public int getSlotLimit(int slot) {
            if (slot == 2 || slot == 3 || slot == 4 || slot == 1) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    private FakePlayer fakePlayer;
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    public static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    public static final int UPGRADE_SLOT_1 = 2;
    public static final int UPGRADE_SLOT_2 = 3;
    public static final int UPGRADE_SLOT_3 = 4;
    private Optional<RecipeHolder<StrainerRecipe>> cachedRecipe = Optional.empty();
    private ItemStack lastInput = ItemStack.EMPTY;
    private ItemStack lastMesh = ItemStack.EMPTY;
    private BlockState lastAboveBlock = Blocks.AIR.defaultBlockState();
    public String errorMessage = "";
    public double outputChanceIncrease = 0.0;
    public static final int[] OUTPUT_SLOTS = new int[33];
    private final IItemHandler strainerItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, this::isInputSlot, this::isOutputSlot);

    private boolean isInputSlot(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return itemStack.is(ModTags.Items.MESHES);
        }
        if (slot == 0) {
            return !itemStack.is(ModTags.Items.MESHES);
        }
        return false;
    }

    private boolean isOutputSlot(int slot) {
        for (int outputSlot : OUTPUT_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.strainerItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public WoodenStrainerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WOODEN_STRAINER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> WoodenStrainerBlockEntity.this.progress;
                    case 1 -> WoodenStrainerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        WoodenStrainerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        WoodenStrainerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = this.createFakePlayer(serverLevel);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.strainers.wooden_strainer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new WoodenStrainerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("strainer.progress", this.progress);
        compoundTag.putInt("strainer.maxProgress", this.maxProgress);
        compoundTag.putDouble("strainer.outputChanceIncrease", this.outputChanceIncrease);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("strainer.progress");
        this.maxProgress = compoundTag.getInt("strainer.maxProgress");
        this.outputChanceIncrease = compoundTag.getDouble("strainer.outputChanceIncrease");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        Level level;
        if (this.fakePlayer == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = this.createFakePlayer(serverLevel);
        }
        this.sync();
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.updateCachedRecipe();
            Optional<RecipeHolder<StrainerRecipe>> match = this.cachedRecipe;
            if (match.isPresent()) {
                this.maxProgress = StrainersIngredientDurations.getDuration(this.itemHandler.getStackInSlot(0));
                this.maxProgress = this.getNewMaxProgress(this.maxProgress);
                StrainerRecipe currentRecipe = (StrainerRecipe)match.get().value();
                if (this.hasCorrectBlockAbove(currentRecipe)) {
                    List<ChanceResult> resultsToRoll = this.getAllCombinedResults(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1));
                    List<ItemStack> results = resultsToRoll.stream().map(r -> r.rollOutput(this.level.random)).filter(r -> !r.isEmpty()).toList();
                    if (!this.canFitResults(results)) {
                        if (!"block.cloche.error.output_full".equals(this.errorMessage)) {
                            this.errorMessage = "block.cloche.error.output_full";
                            this.sync();
                        }
                        return;
                    }
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        this.resetProgress();
                        this.fillOutputSlots(results);
                        this.sync();
                    }
                }
            } else {
                this.resetProgress();
            }
        }
    }

    public int getNewMaxProgress(int adjustedMaxProgress) {
        ItemStack[] upgradeSlots;
        int newMaxProgress = adjustedMaxProgress;
        ItemStack upgradeSlot1 = this.itemHandler.getStackInSlot(2);
        ItemStack upgradeSlot2 = this.itemHandler.getStackInSlot(3);
        ItemStack upgradeSlot3 = this.itemHandler.getStackInSlot(4);
        for (ItemStack upgradeSlot : upgradeSlots = new ItemStack[]{upgradeSlot1, upgradeSlot2, upgradeSlot3}) {
            Item item;
            if (upgradeSlot.isEmpty() || !((item = upgradeSlot.getItem()) instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            newMaxProgress -= upgradeItem.getSpeedReduction();
        }
        return Math.max(20, newMaxProgress);
    }

    public void fillOutputSlots(List<ItemStack> results) {
        ItemStack meshItem;
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (!inputStack.is(ModTags.Items.NOT_CONSUMED)) {
            inputStack.shrink(1);
        }
        if ((meshItem = this.itemHandler.getStackInSlot(1)).isDamageableItem()) {
            meshItem.hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(meshItem));
            if (meshItem.getCount() <= 0) {
                this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
        }
        block0: for (ItemStack result : results) {
            for (int outputSlot : OUTPUT_SLOTS) {
                int maxStackSize;
                int spaceLeft;
                ItemStack slotStack = this.itemHandler.getStackInSlot(outputSlot);
                if (slotStack.isEmpty()) {
                    this.itemHandler.setStackInSlot(outputSlot, result.copy());
                    result.setCount(0);
                    continue block0;
                }
                if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)result) || (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) <= 0) continue;
                int toAdd = Math.min(spaceLeft, result.getCount());
                slotStack.grow(toAdd);
                result.shrink(toAdd);
                if (result.isEmpty()) continue block0;
            }
        }
    }

    private List<ChanceResult> getAllCombinedResults(ItemStack inputStack, ItemStack meshStack) {
        assert (this.level != null);
        RecipeManager recipeManager = this.level.getRecipeManager();
        List<StrainerRecipe> matchingRecipes = recipeManager.getAllRecipesFor(ModRecipes.STRAINER_TYPE.get()).stream().map(RecipeHolder::value).filter(recipe -> recipe.input().test(inputStack)).filter(this::hasCorrectBlockAbove).toList();
        ArrayList<ChanceResult> combinedResults = new ArrayList<ChanceResult>();
        for (StrainerRecipe recipe2 : matchingRecipes) {
            for (MeshChanceResult meshChance : recipe2.getRollResults()) {
                if (meshChance == MeshChanceResult.EMPTY || !meshChance.mesh().isEmpty() && !meshChance.mesh().test(meshStack)) continue;
                ChanceResult original = meshChance.chanceResult();
                ChanceResult booster = this.applyUpgradeBoost(original);
                combinedResults.add(booster);
            }
        }
        return combinedResults;
    }

    private ChanceResult applyUpgradeBoost(ChanceResult original) {
        ItemStack[] upgradeSlots;
        double newChance = original.chance();
        ItemStack upgradeSlot1 = this.itemHandler.getStackInSlot(2);
        ItemStack upgradeSlot2 = this.itemHandler.getStackInSlot(3);
        ItemStack upgradeSlot3 = this.itemHandler.getStackInSlot(4);
        for (ItemStack upgradeSlot : upgradeSlots = new ItemStack[]{upgradeSlot1, upgradeSlot2, upgradeSlot3}) {
            Item item;
            if (upgradeSlot.isEmpty() || !((item = upgradeSlot.getItem()) instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)item;
            newChance += upgradeItem.getOutputIncrease();
        }
        double boostedChance = (double)original.chance() + Math.min(1.0, newChance);
        return new ChanceResult(original.stack(), (float)boostedChance);
    }

    private boolean hasCorrectBlockAbove(StrainerRecipe recipe) {
        return recipe.getBlockAbove() == this.getBlockAbove();
    }

    private void updateCachedRecipe() {
        if (this.inputsChanged()) {
            StrainerRecipeInput inventory = new StrainerRecipeInput(this.itemHandler, this.worldPosition);
            this.cachedRecipe = this.level.getRecipeManager().getRecipeFor((RecipeType)StrainerRecipe.Type.INSTANCE, (RecipeInput)inventory, this.level);
            this.lastInput = this.itemHandler.getStackInSlot(0).copy();
            this.lastMesh = this.itemHandler.getStackInSlot(1).copy();
            this.lastAboveBlock = this.getBlockAbove();
        }
    }

    public BlockState getBlockAbove() {
        BlockPos blockPos = this.worldPosition.above();
        assert (this.level != null);
        BlockState state = this.level.getBlockState(blockPos);
        BlockEntity be = this.level.getBlockEntity(blockPos);
        if (be instanceof StrainerTankBlockEntity) {
            StrainerTankBlockEntity tank = (StrainerTankBlockEntity)be;
            Fluid fluid = tank.FLUID_TANK.getFluid().getFluid();
            if (!fluid.getFluidType().isAir()) {
                return fluid.defaultFluidState().createLegacyBlock();
            }
        }
        return state;
    }

    private boolean inputsChanged() {
        return !ItemStack.matches((ItemStack)this.itemHandler.getStackInSlot(0), (ItemStack)this.lastInput) || !ItemStack.matches((ItemStack)this.itemHandler.getStackInSlot(1), (ItemStack)this.lastMesh) || this.getBlockAbove() != this.lastAboveBlock;
    }

    public boolean canFitResults(List<ItemStack> results) {
        for (ItemStack result : results) {
            int remainingToFit = result.getCount();
            for (int outputSlot : OUTPUT_SLOTS) {
                int maxStackSize;
                int spaceLeft;
                ItemStack slotStack = this.itemHandler.getStackInSlot(outputSlot);
                if (slotStack.isEmpty()) {
                    remainingToFit = 0;
                    break;
                }
                if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)result) && (spaceLeft = (maxStackSize = slotStack.getMaxStackSize()) - slotStack.getCount()) > 0 && (remainingToFit -= spaceLeft) <= 0) break;
            }
            if (remainingToFit <= 0) continue;
            return false;
        }
        return true;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = Integer.MAX_VALUE;
    }

    private FakePlayer createFakePlayer(ServerLevel level) {
        return new FakePlayer(level, new GameProfile(UUID.randomUUID(), "Strainer"));
    }

    static {
        for (int i = 0; i < OUTPUT_SLOTS.length; ++i) {
            WoodenStrainerBlockEntity.OUTPUT_SLOTS[i] = 5 + i;
        }
    }
}

